/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.autodata;

import org.jetbrains.annotations.NotNull;
import org.panda_lang.panda.utilities.autodata.AutomatedDataException;
import org.panda_lang.panda.utilities.autodata.AutomatedDataSpace;
import org.panda_lang.panda.utilities.autodata.collection.ADSCollection;

public class AutomatedDataInterface {
    private final AutomatedDataSpace automatedDataSpace;

    protected AutomatedDataInterface(AutomatedDataSpace automatedDataSpace) {
        this.automatedDataSpace = automatedDataSpace;
    }

    public <T> T get(String collectionName, Class<T> type, Object query) {
        ADSCollection<?> collection = this.selectCollection(collectionName, type);
        return (T)collection.get(query);
    }

    public void post(String collectionName, Object element) {
        ADSCollection<?> collection = this.selectCollection(collectionName, element.getClass());
        collection.post(element);
    }

    public void loadAll() {
    }

    public void saveAll() {
    }

    @NotNull
    private ADSCollection<?> selectCollection(String collectionName, Class<?> type) {
        ADSCollection collection = this.automatedDataSpace.getCollection(collectionName);
        if (collection == null) {
            throw new AutomatedDataException("Collection of " + type + " does not exist");
        }
        if (type != null && collection.getType() != type) {
            throw new AutomatedDataException("Cannot get " + type + " from collection of " + collection.getType());
        }
        return collection;
    }
}

