/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons;

import java.util.function.Supplier;
import org.panda_lang.panda.utilities.commons.objects.TimeUtils;

public class BenchmarkUtils {
    public static void execute(String title, Runnable runnable) {
        long time = System.nanoTime();
        runnable.run();
        System.out.println("[" + title + "] " + TimeUtils.toMilliseconds(System.nanoTime() - time));
    }

    public static <T> T execute(String title, Supplier<T> runnable) {
        long time = System.nanoTime();
        T value = runnable.get();
        System.out.println("[" + title + "] " + TimeUtils.toMilliseconds(System.nanoTime() - time));
        return value;
    }

    public static void print(long start, int av, String message) {
        long nsDif = System.nanoTime() - start;
        float msDif = (float)nsDif / 1000000.0f;
        float sDif = msDif / 1000.0f;
        float mDif = sDif / 60.0f;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    ns: ");
        stringBuilder.append(nsDif);
        stringBuilder.append(" | av: ");
        stringBuilder.append(nsDif / (long)av);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    ms: ");
        stringBuilder.append(msDif);
        stringBuilder.append(" | av: ");
        stringBuilder.append(msDif / (float)av);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    s: ");
        stringBuilder.append(sDif);
        stringBuilder.append(" | av: ");
        stringBuilder.append(sDif / (float)av);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("    m: ");
        stringBuilder.append(mDif);
        stringBuilder.append(" | av: ");
        stringBuilder.append(mDif / (float)av);
        stringBuilder.append(System.lineSeparator());
        System.out.println(stringBuilder);
    }
}

