/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class Multimap<K, V>
implements Serializable {
    private final Map<K, Collection<V>> map;
    private final Supplier<Collection<V>> collectionSupplier;

    public Multimap(Map<K, Collection<V>> map, Supplier<Collection<V>> collectionSupplier) {
        this.map = map;
        this.collectionSupplier = collectionSupplier;
    }

    public void put(K key, V value) {
        Collection collection = this.map.computeIfAbsent(key, k -> this.collectionSupplier.get());
        collection.add(value);
    }

    public void put(K key, Collection<V> values) {
        Collection collection = this.map.computeIfAbsent(key, k -> this.collectionSupplier.get());
        collection.addAll(values);
    }

    public void clear() {
        this.map.clear();
    }

    @Nullable
    public Collection<V> get(K key) {
        return this.map.get(key);
    }
}

