/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class IOUtils {
    public static InputStream convertStringToStream(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String convertStreamToString(InputStream inputStream) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(result);
            IOUtils.close(inputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getURLContent(String s) {
        String body = null;
        InputStream in = null;
        try {
            URL url = new URL(s);
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            in = con.getInputStream();
            String encoding = con.getContentEncoding();
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            body = IOUtils.toString(in, charset);
            in.close();
            IOUtils.close(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(in);
        }
        return body;
    }

    public static String toString(InputStream in, String encoding) {
        return IOUtils.toString(in, Charset.forName(encoding));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String toString(InputStream in, Charset encoding) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) != -1) {
                byteArrayOutputStream.write(buf, 0, len);
            }
            String string = new String(byteArrayOutputStream.toByteArray(), encoding);
            return string;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

