/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.objects;

import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;

public class StringUtils {
    public static final String EMPTY = "";

    public static String isEmpty(String text, String exceptionMessage) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return text;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static String replace(String text, String searchString, String replacement) {
        if (text == null || text.isEmpty() || searchString.isEmpty()) {
            return text;
        }
        if (replacement == null) {
            replacement = EMPTY;
        }
        int start = 0;
        int max = -1;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replaceLength = searchString.length();
        int increase = replacement.length() - replaceLength;
        increase = increase < 0 ? 0 : increase;
        StringBuilder sb = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            sb.append(text, start, end).append(replacement);
            start = end + replaceLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        sb.append(text.substring(start));
        return sb.toString();
    }

    public static String capitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodePoint = str.codePointAt(0);
        if (firstCodePoint == (newCodePoint = Character.toTitleCase(firstCodePoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodePoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String trimStart(String s) {
        int i;
        char[] val = s.toCharArray();
        for (i = 0; i < val.length && val[i] <= ' '; ++i) {
        }
        return s.substring(i, val.length);
    }

    public static String trimEnd(String s) {
        int len;
        char[] val = s.toCharArray();
        for (len = s.length(); len > 0 && val[len - 1] <= ' '; --len) {
        }
        return s.substring(0, len);
    }

    public static String extractParagraph(String str) {
        int count = str.indexOf(str.trim());
        return str.substring(0, count);
    }

    public static int countOccurrences(String str, String findStr) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(findStr, lastIndex)) == -1) continue;
            ++count;
            lastIndex += findStr.length();
        }
        return count;
    }

    public static boolean containsCharacter(String string, char ... characters) {
        for (char c : string.toCharArray()) {
            for (char character : characters) {
                if (c != character) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsSpecialCharacters(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOtherCharacters(String str, char[] ... characters) {
        for (char c : str.toCharArray()) {
            if (CharacterUtils.belongsTo(c, characters)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c) || c == 'x' || c == '.') continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String toCharCodes(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : str.toCharArray()) {
            stringBuilder.append((int)c);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String createIndentation(int spaces) {
        StringBuilder gapBuilder = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            gapBuilder.append(" ");
        }
        return gapBuilder.toString();
    }
}

