/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.pattern.text;

import java.util.ArrayList;
import java.util.Collection;
import org.panda_lang.panda.utilities.commons.pattern.PatternMatcher;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowSymbolType;

public class TextHollowSymbol
implements PatternMatcher {
    private final int index;
    private final TextHollowSymbolType hollowSymbolType;
    private final Collection<String> segmentsBefore;
    private final Collection<String> variants;
    private final Collection<String> segmentsAfter;

    public TextHollowSymbol(TextHollowSymbolType hollowSymbolType, int index) {
        this.index = index;
        this.hollowSymbolType = hollowSymbolType;
        this.segmentsBefore = new ArrayList<String>(1);
        this.variants = new ArrayList<String>(1);
        this.segmentsAfter = new ArrayList<String>(1);
    }

    @Override
    public boolean match(String expression) {
        for (String variant : this.variants) {
            if (!variant.equals(expression)) continue;
            return true;
        }
        return false;
    }

    public void addSegmentBefore(String segment) {
        this.segmentsBefore.add(segment);
    }

    public void addVariant(String variant) {
        this.variants.add(variant);
    }

    public void addSegmentAfter(String segment) {
        this.segmentsAfter.add(segment);
    }

    public boolean isOptional() {
        return this.hollowSymbolType == TextHollowSymbolType.OPTIONAL;
    }

    public boolean isHollow() {
        return this.hollowSymbolType == TextHollowSymbolType.HOLLOW;
    }

    public boolean isBasis() {
        return this.hollowSymbolType == TextHollowSymbolType.BASIS;
    }

    public Collection<String> getSegmentsBefore() {
        return this.segmentsBefore;
    }

    public Collection<String> getSegmentsAfter() {
        return this.segmentsAfter;
    }

    public Collection<String> getVariants() {
        return this.variants;
    }

    public TextHollowSymbolType getHollowSymbolType() {
        return this.hollowSymbolType;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        switch (this.getHollowSymbolType()) {
            case BASIS: {
                return this.variants.toString();
            }
            case HOLLOW: {
                return "*";
            }
            case OPTIONAL: {
                return this.segmentsBefore + "[ ]" + this.segmentsAfter;
            }
        }
        return "<unknown type>";
    }
}

