/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.redact;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class ContentJoiner {
    private final String separator;
    private final StringBuilder builder;

    private ContentJoiner(String separator) {
        this.separator = separator;
        this.builder = new StringBuilder();
    }

    public <T> ContentJoiner join(T[] elements, Function<T, ?> mapper) {
        return this.join(Arrays.asList(elements), mapper);
    }

    public <T> ContentJoiner join(Collection<T> elements, Function<T, ?> mapper) {
        for (T element : elements) {
            this.append(mapper.apply(element));
        }
        return this;
    }

    public ContentJoiner join(Object ... elements) {
        return this.join(Arrays.asList(elements));
    }

    public ContentJoiner join(Collection<?> elements) {
        for (Object element : elements) {
            this.append(element);
        }
        return this;
    }

    public ContentJoiner append(Object element) {
        this.builder.append(element).append(this.separator);
        return this;
    }

    public String toString() {
        return this.builder.substring(0, this.builder.length() - this.separator.length());
    }

    public static ContentJoiner on(String separator) {
        return new ContentJoiner(separator);
    }
}

