/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.panda_lang.panda.utilities.configuration.ConfigurationEntry;
import org.panda_lang.panda.utilities.configuration.ConfigurationObject;
import org.panda_lang.panda.utilities.configuration.ConfigurationType;
import org.panda_lang.panda.utilities.configuration.ConfigurationUtils;

public class ConfigurationParser {
    private final String[] code;
    private final Map<String, ConfigurationObject> map;

    protected ConfigurationParser(String[] code) {
        this.code = code;
        this.map = new HashMap<String, ConfigurationObject>();
        this.run();
    }

    protected void run() {
        Stack<String> keys = new Stack<String>();
        Stack<Character> operators = new Stack<Character>();
        StringBuilder chars = new StringBuilder();
        ConfigurationEntry entry = new ConfigurationEntry();
        int lastPosition = 0;
        entry.setValue(new ArrayList());
        for (String line : this.code) {
            char c;
            String rx;
            if (line == null || line.isEmpty() || "".equals(rx = line.replaceAll("\\s", "")) || rx.startsWith("#")) continue;
            int charPos = 0;
            chars.setLength(0);
            int whitespace = 0;
            boolean separator = false;
            boolean apostrophe = false;
            boolean aBeen = false;
            boolean skip = false;
            block20: for (char c2 : line.toCharArray()) {
                ++charPos;
                switch (c2) {
                    case ' ': {
                        if (!apostrophe && chars.length() == 0) {
                            ++whitespace;
                            continue block20;
                        }
                        chars.append(c2);
                        break;
                    }
                    case '\'': {
                        if (chars.length() == 0) {
                            if (apostrophe) {
                                aBeen = true;
                                skip = true;
                                break;
                            }
                            apostrophe = true;
                            continue block20;
                        }
                        if (line.length() == charPos) {
                            apostrophe = false;
                            aBeen = true;
                            continue block20;
                        }
                        chars.append(c2);
                        break;
                    }
                    case ':': {
                        if (!separator) {
                            if (!operators.isEmpty() && ((Character)operators.peek()).charValue() == '-') {
                                chars.append(c2);
                                break;
                            }
                            int position = whitespace / 2;
                            this.patchPosition(position, lastPosition, keys);
                            keys.push(chars.toString());
                            operators.push(Character.valueOf(c2));
                            chars.setLength(0);
                            separator = true;
                            break;
                        }
                        chars.append(c2);
                        break;
                    }
                    case '-': {
                        if (chars.length() == 0) {
                            operators.push(Character.valueOf(c2));
                            break;
                        }
                        chars.append(c2);
                        break;
                    }
                    case '[': {
                        if (chars.length() == 0) {
                            operators.push(Character.valueOf(c2));
                            break;
                        }
                        chars.append(c2);
                        break;
                    }
                    case ']': {
                        if (chars.length() == 0) {
                            operators.push(Character.valueOf(c2));
                            break;
                        }
                        chars.append(c2);
                        break;
                    }
                    default: {
                        chars.append(c2);
                    }
                }
                if (skip) break;
            }
            int position = whitespace / 2;
            String string = chars.toString();
            chars.setLength(0);
            if (operators.isEmpty()) {
                lastPosition = position;
                continue;
            }
            if (keys.isEmpty()) {
                if (string.isEmpty()) continue;
                c = ((Character)operators.pop()).charValue();
                switch (c) {
                    case '-': {
                        if (entry.getKey() == null) {
                            entry.setKey(ConfigurationUtils.getPath(keys));
                        }
                        if (entry.getValue() == null) {
                            entry.setValue(new ArrayList());
                        }
                        ((Collection)entry.getValue()).add(string);
                        break;
                    }
                    default: {
                        operators.push(Character.valueOf(c));
                        break;
                    }
                }
                continue;
            }
            if (!aBeen && string.isEmpty()) {
                c = ((Character)operators.pop()).charValue();
                switch (c) {
                    case ']': {
                        if (((Character)operators.peek()).charValue() != '[') break;
                        operators.pop();
                        ConfigurationObject co = new ConfigurationObject(ConfigurationType.LIST);
                        co.setObject(new ArrayList());
                        this.addEntry(ConfigurationUtils.getPath(keys), co);
                        keys.pop();
                        break;
                    }
                    case ':': {
                        if (((Collection)entry.getValue()).isEmpty()) break;
                        ConfigurationObject lo = new ConfigurationObject(ConfigurationType.LIST);
                        lo.setObject(entry.getValue());
                        lo.setPosition(position);
                        this.addEntry((String)entry.getKey(), lo);
                        entry = new ConfigurationEntry();
                        entry.setValue(new ArrayList());
                        break;
                    }
                    default: {
                        operators.push(Character.valueOf(c));
                    }
                }
                lastPosition = position;
                continue;
            }
            switch (((Character)operators.pop()).charValue()) {
                case '-': {
                    if (entry.getKey() == null) {
                        entry.setKey(ConfigurationUtils.getPath(keys));
                        keys.pop();
                    }
                    if (entry.getValue() == null) {
                        entry.setValue(new ArrayList());
                    }
                    ((Collection)entry.getValue()).add(string);
                    break;
                }
                case ':': {
                    String key = keys.pop();
                    this.patchPosition(position, lastPosition, keys);
                    if (!((Collection)entry.getValue()).isEmpty()) {
                        ConfigurationObject lo = new ConfigurationObject(ConfigurationType.LIST);
                        lo.setObject(entry.getValue());
                        lo.setPosition(position);
                        this.addEntry(ConfigurationUtils.getPath(keys), lo);
                        if (keys.size() != 0) {
                            keys.pop();
                        }
                        entry = new ConfigurationEntry();
                        entry.setValue(new ArrayList());
                    }
                    keys.push(key);
                    ConfigurationObject co = new ConfigurationObject(ConfigurationType.STRING);
                    co.setObject(string);
                    co.setPosition(position);
                    this.addEntry(ConfigurationUtils.getPath(keys), co);
                    keys.pop();
                }
            }
            lastPosition = position;
        }
        if (!((Collection)entry.getValue()).isEmpty()) {
            ConfigurationObject lo = new ConfigurationObject(ConfigurationType.LIST);
            lo.setObject(entry.getValue());
            this.addEntry((String)entry.getKey(), lo);
        }
    }

    private void addEntry(String s, ConfigurationObject co) {
        this.map.put(s, co);
    }

    private void patchPosition(int position, int lastPosition, Stack<String> keys) {
        if (lastPosition != position && lastPosition > position) {
            int backspace = lastPosition - position;
            if (keys.size() >= backspace) {
                for (int i = 0; i < backspace; ++i) {
                    keys.pop();
                }
            }
        }
    }

    public void print() {
        for (Map.Entry<String, ConfigurationObject> entry : this.map.entrySet()) {
            if (entry.getValue().getType() == ConfigurationType.STRING) {
                String s = (String)entry.getValue().getObject();
                System.out.println(entry.getKey() + ": " + s);
                continue;
            }
            System.out.println(entry.getKey() + ": ");
            for (String s : (List)entry.getValue().getObject()) {
                System.out.println("- " + s);
            }
        }
    }

    protected Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, ConfigurationObject> entry : this.map.entrySet()) {
            if (entry.getKey() == null) continue;
            map.put(entry.getKey(), entry.getValue().getObject());
        }
        return map;
    }
}

