/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.commons.io.FileUtils;
import org.panda_lang.panda.utilities.configuration.ConfigurationFile;
import org.panda_lang.panda.utilities.configuration.ConfigurationParser;

@Deprecated
public class PandaConfiguration {
    private File configuration;
    private Map<String, Object> map;

    public PandaConfiguration() {
        this.map = new HashMap<String, Object>();
    }

    public PandaConfiguration(File file) {
        String[] source = FileUtils.getContentAsLines(file);
        ConfigurationParser configurationParser = new ConfigurationParser(source);
        this.configuration = file;
        this.map = configurationParser.getMap();
    }

    public PandaConfiguration(String content) {
        String[] source = content.split("\n");
        ConfigurationParser configurationParser = new ConfigurationParser(source);
        this.map = configurationParser.getMap();
    }

    @Nullable
    public ConfigurationFile save() {
        if (this.configuration == null) {
            return null;
        }
        ConfigurationFile file = new ConfigurationFile(this.configuration, this);
        file.save();
        return file;
    }

    public ConfigurationFile save(File file) {
        this.configuration = file;
        ConfigurationFile configurationFile = new ConfigurationFile(file, this);
        configurationFile.save();
        return configurationFile;
    }

    public void set(String path, Object object) {
        this.map.put(path, object);
    }

    public boolean containsKey(String path) {
        return this.map.containsKey(path);
    }

    @Nullable
    public String getString(String path) {
        Object co = this.map.get(path);
        if (co instanceof String) {
            return co.toString();
        }
        return null;
    }

    public boolean getBoolean(String path) {
        Object co = this.map.get(path);
        if (co instanceof String) {
            return Boolean.parseBoolean((String)co);
        }
        return false;
    }

    public int getInt(String path) {
        Object co = this.map.get(path);
        if (co instanceof String) {
            return Integer.parseInt((String)co);
        }
        return 0;
    }

    public long getLong(String path) {
        Object co = this.map.get(path);
        if (co instanceof String) {
            return Long.parseLong((String)co);
        }
        return 0L;
    }

    public double getDouble(String path) {
        Object co = this.map.get(path);
        if (co instanceof String) {
            return Double.parseDouble((String)co);
        }
        return 0.0;
    }

    @Nullable
    public List<String> getStringList(String path) {
        if (this.map.containsKey(path)) {
            Object co = this.map.get(path);
            if (co instanceof List) {
                return (List)co;
            }
            return new ArrayList<String>();
        }
        return null;
    }

    public Collection<String> getSectionKeys(String path) {
        ArrayList<String> list = new ArrayList<String>();
        path = path + ".";
        for (String key : this.map.keySet()) {
            if (!key.startsWith(path)) continue;
            list.add(key.substring(path.length()));
        }
        return list;
    }

    public void clear() {
        this.configuration = null;
        this.map = null;
    }

    public Object get(String path) {
        return this.map.get(path);
    }

    public Collection<String> getKeys() {
        return new ArrayList<String>(this.map.keySet());
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public File getConfigurationFile() {
        return this.configuration;
    }
}

