/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium;

import java.awt.Toolkit;
import org.panda_lang.pandomium.PandomiumLogger;
import org.panda_lang.pandomium.loader.PandomiumLoader;
import org.panda_lang.pandomium.loader.PandomiumProgressListener;
import org.panda_lang.pandomium.settings.PandomiumSettings;
import org.panda_lang.pandomium.wrapper.PandomiumCEF;
import org.panda_lang.pandomium.wrapper.PandomiumClient;
import org.slf4j.Logger;

public class Pandomium {
    private final PandomiumSettings settings;
    private final PandomiumLoader loader;
    private final Thread mainThread;
    private PandomiumCEF pcef;

    public Pandomium(PandomiumSettings settings) {
        this.settings = settings;
        this.loader = new PandomiumLoader(this);
        this.mainThread = Thread.currentThread();
    }

    public void initialize() {
        Toolkit.getDefaultToolkit();
        this.loader.addProgressListener((state, progress) -> {
            if (state != PandomiumProgressListener.State.DONE) {
                return;
            }
            this.pcef = new PandomiumCEF(this);
            this.pcef.initialize();
        });
        this.loader.load();
    }

    public PandomiumClient createClient() {
        if (this.pcef == null) {
            throw new RuntimeException("Pandomium is not initialized");
        }
        return this.pcef.createClient();
    }

    public PandomiumCEF getRaw() {
        return this.pcef;
    }

    public PandomiumLoader getLoader() {
        return this.loader;
    }

    public PandomiumSettings getSettings() {
        return this.settings;
    }

    public static Logger getLogger() {
        return PandomiumLogger.PANDOMIUM_LOGGER;
    }

    public static String getChromiumVersion() {
        return "67.0.3396.62";
    }

    public static String getCefVersion() {
        return "3.3396.1775.g5340bb0";
    }

    public static String getVersion() {
        return "67.0.4";
    }
}

