/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.loader;

import org.panda_lang.pandomium.Pandomium;
import org.panda_lang.pandomium.loader.PandomiumLoader;
import org.panda_lang.pandomium.loader.PandomiumNativesLoader;
import org.panda_lang.pandomium.loader.PandomiumProgressListener;
import org.panda_lang.pandomium.loader.os.PandomiumLinuxNativesLoader;
import org.panda_lang.pandomium.settings.PandomiumSettings;
import org.panda_lang.pandomium.settings.categories.NativesSettings;
import org.panda_lang.pandomium.util.SystemUtils;
import org.panda_lang.pandomium.util.os.PandomiumOS;

public class PandomiumLoaderWorker
implements Runnable {
    private final PandomiumLoader loader;

    public PandomiumLoaderWorker(PandomiumLoader loader) {
        this.loader = loader;
    }

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() throws Exception {
        this.loader.updateProgress(0);
        PandomiumNativesLoader nativeLoader = new PandomiumNativesLoader();
        nativeLoader.loadNatives(this.loader);
        Pandomium pandomium = this.loader.getPandomium();
        PandomiumSettings settings = pandomium.getSettings();
        NativesSettings nativesSettings = settings.getNatives();
        String nativePath = nativesSettings.getNativeDirectory();
        SystemUtils.injectLibraryPath(nativePath);
        if (PandomiumOS.isLinux()) {
            PandomiumLinuxNativesLoader linuxNativesLoader = new PandomiumLinuxNativesLoader();
            linuxNativesLoader.loadLinuxNatives(nativePath);
        }
        this.loader.updateProgress(100);
        this.loader.callListeners(PandomiumProgressListener.State.DONE);
    }
}

