/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509Read {
    public static void main(String[] args) throws Exception {
        String keystoreFile = "/home/marcarvalho/Dropbox/cert/tomcat-truststore.jks";
        String keystoreOutFile = "/home/marcarvalho/Dropbox/cert/tomcatx.jks";
        String caAlias = "iti";
        String certToSignAlias = "marco";
        String newAlias = "marco";
        char[] password = "tomcat".toCharArray();
        char[] caPassword = "tomcat".toCharArray();
        char[] certPassword = "Marina#01".toCharArray();
        FileInputStream input = new FileInputStream(keystoreFile);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(input, password);
        input.close();
        PrivateKey caPrivateKey = (PrivateKey)keyStore.getKey(caAlias, caPassword);
        Certificate caCert = keyStore.getCertificate(caAlias);
        byte[] encoded = caCert.getEncoded();
        X509CertImpl caCertImpl = new X509CertImpl(encoded);
        X509CertInfo caCertInfo = (X509CertInfo)caCertImpl.get("x509.info");
        X500Name issuer = (X500Name)caCertInfo.get("subject.dname");
        Certificate cert = keyStore.getCertificate(certToSignAlias);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(certToSignAlias, certPassword);
        System.out.println("cert:" + cert.toString());
        System.out.println("PK:" + privateKey.getEncoded());
        encoded = cert.getEncoded();
        X509CertImpl certImpl = new X509CertImpl(encoded);
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        Date firstDate = new Date();
        Date lastDate = new Date(firstDate.getTime() + 31536000000L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber((int)(firstDate.getTime() / 1000L)));
        certInfo.set("issuer.dname", issuer);
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        certInfo.set("algorithmID.algorithm", algorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(caPrivateKey, "MD5WithRSA");
        keyStore.setKeyEntry(newAlias, privateKey, certPassword, new Certificate[]{newCert});
        FileOutputStream output = new FileOutputStream(keystoreOutFile);
        keyStore.store(output, password);
        output.close();
    }
}

