/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate.oid;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDGeneric {
    private static final Logger logger = LoggerFactory.getLogger(OIDGeneric.class);
    private String oid = null;
    private String data = null;
    protected Map<String, String> properties = new HashMap<String, String>();

    public static OIDGeneric getInstance(byte[] data) throws IOException, Exception {
        OIDGeneric oidGenerico;
        ASN1InputStream is = new ASN1InputStream(data);
        DERSequence sequence = (DERSequence)is.readObject();
        DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)sequence.getObjectAt(0);
        DERTaggedObject tag = (DERTaggedObject)sequence.getObjectAt(1);
        DEROctetString octetString = null;
        DERPrintableString printableString = null;
        DERUTF8String utf8String = null;
        DERIA5String ia5String = null;
        try {
            octetString = (DEROctetString)DEROctetString.getInstance(tag);
        }
        catch (Exception ex) {
            try {
                printableString = DERPrintableString.getInstance(tag);
            }
            catch (Exception e1) {
                try {
                    utf8String = DERUTF8String.getInstance(tag);
                }
                catch (Exception e2) {
                    ia5String = DERIA5String.getInstance(tag);
                }
            }
        }
        String className = "x2br.security.certificate.oid.OID_" + objectIdentifier.getId().replaceAll("[.]", "_");
        try {
            oidGenerico = (OIDGeneric)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new Exception("Can not instace class '" + className + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Was not possible instace class '" + className + "'.", e);
        }
        catch (ClassNotFoundException e) {
            oidGenerico = new OIDGeneric();
        }
        oidGenerico.setOid(objectIdentifier.getId());
        if (octetString != null) {
            oidGenerico.setData(new String(octetString.getOctets()));
        } else if (printableString != null) {
            oidGenerico.setData(printableString.getString());
        } else if (utf8String != null) {
            oidGenerico.setData(utf8String.getString());
        } else {
            oidGenerico.setData(ia5String.getString());
        }
        oidGenerico.initialize();
        return oidGenerico;
    }

    protected void initialize() {
    }

    protected void initialize(Object[] fields) {
        int tmp = 0;
        for (int i = 0; i < fields.length; i += 2) {
            String key = (String)fields[i];
            int size = ((Number)fields[i + 1]).intValue();
            this.properties.put(key, this.data.substring(tmp, Math.min(tmp + size, this.data.length())));
            tmp += size;
        }
    }

    public String getOid() {
        return this.oid;
    }

    public String getData() {
        return this.data;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public void setData(String data) {
        this.data = data;
    }
}

