/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Constants;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import x2br.security.signer.DriverNotAvailableException;
import x2br.security.signer.InvalidPinException;
import x2br.security.signer.KeyStoreLoader;
import x2br.security.signer.KeyStoreLoaderException;
import x2br.security.signer.PKCS11NotFoundException;
import x2br.security.signer.core.pkcs11.DriverManager;
import x2br.security.signer.core.pkcs11.PKCS11ErrorMessages;
import x2br.security.signer.core.util.ExceptionUtil;
import x2br.security.signer.core.util.MessagesBundle;

public class DriverKeyStoreLoader
implements KeyStoreLoader {
    private static final String PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String SUN_PKCS11_PROVIDER_CLASS = "sun.security.pkcs11.SunPKCS11";
    private static final String PKCS11_CONTENT_CONFIG_FILE = "name = %s\nlibrary = %s";
    private static String lastPkcs11Provider = "";
    private static String lastDriverName = "";
    private static String lastDriverPath = "";
    private CallbackHandler callback;
    private Formatter formatter;
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    @Override
    public KeyStore getKeyStore() {
        String configFile = DriverManager.getInstance().getPKCS11ConfigFile();
        if (configFile != null) {
            return this.getKeyStoreFromConfigFile(configFile);
        }
        return this.getKeyStoreFromDrivers();
    }

    public KeyStore getKeyStoreFromDriver(String driverPath) {
        String driverName = driverPath.replaceAll("\\\\", "/");
        int begin = driverName.lastIndexOf("/");
        begin = begin <= -1 ? 0 : begin + 1;
        int end = driverName.length();
        driverName = driverName.substring(begin, end);
        return this.getKeyStoreFromDriver(driverName, driverPath);
    }

    public KeyStore getKeyStoreFromDriver(String driverName, String driverPath) {
        try {
            DriverManager.getInstance().addDriver(driverName, driverPath);
            Object keyStore = null;
            this.formatter = new Formatter();
            System.out.println("NOME:" + driverName + "  LIB:" + driverPath);
            OptionalLong slot = this.getSlot(driverPath);
            System.out.println("===>  SLOT:" + slot.toString());
            if (slot.isPresent()) {
                ByteArrayInputStream confStream = this.createConfig(driverName, driverPath, slot.getAsLong());
                lastDriverName = driverName;
                lastDriverPath = driverPath;
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(DriverKeyStoreLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (PKCS11Exception ex) {
            Logger.getLogger(DriverKeyStoreLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public KeyStore getKeyStoreFromDriver(ByteArrayInputStream confStream) {
        KeyStore keyStore = null;
        try {
            SunPKCS11 pkcs11Provider = new SunPKCS11((InputStream)confStream);
            Security.addProvider(pkcs11Provider);
            pkcs11Provider.login(null, this.callback);
            keyStore = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE, pkcs11Provider.getName());
            keyStore.load(null, null);
        }
        catch (IOException | IllegalArgumentException | SecurityException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | LoginException ex) {
            Throwable rootCause = ExceptionUtil.getRootException(ex);
            System.out.println("CAUSA:" + rootCause);
            if (rootCause instanceof PKCS11Exception) {
                String errorCodeName = ((PKCS11Exception)rootCause).getLocalizedMessage();
                throw new InvalidPinException(PKCS11ErrorMessages.getErrorMessage(errorCodeName), rootCause);
            }
            if (ex.getCause().toString().equals("javax.security.auth.login.FailedLoginException")) {
                throw new InvalidPinException(coreMessagesBundle.getString("error.pin.invalid"), ex);
            }
            if (ex.getCause().toString().equals("javax.security.auth.login.LoginException")) {
                throw new InvalidPinException(coreMessagesBundle.getString("error.pin.invalid"), ex);
            }
            throw new PKCS11NotFoundException(coreMessagesBundle.getString("error.load.module.pcks11"), ex);
        }
        return keyStore;
    }

    private KeyStore getKeyStoreFromConfigFile(String configFile) {
        KeyStore keyStore = null;
        try {
            Constructor<?> construtor = Class.forName(SUN_PKCS11_PROVIDER_CLASS).getConstructor(String.class);
            Provider pkcs11Provider = (Provider)construtor.newInstance(configFile);
            Security.addProvider(pkcs11Provider);
            Method login = Class.forName(SUN_PKCS11_PROVIDER_CLASS).getMethod("login", Subject.class, CallbackHandler.class);
            login.invoke((Object)Security.getProvider(pkcs11Provider.getName()), null, this.callback);
            keyStore = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE, pkcs11Provider.getName());
            keyStore.load(null, null);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            if (ex.getCause().toString().equals("javax.security.auth.login.FailedLoginException")) {
                throw new InvalidPinException(coreMessagesBundle.getString("error.pin.invalid"), ex);
            }
            if (ex.getCause().toString().equals("javax.security.auth.login.LoginException")) {
                throw new InvalidPinException(coreMessagesBundle.getString("error.pin.invalid"), ex);
            }
            throw new PKCS11NotFoundException(coreMessagesBundle.getString("error.load.module.pcks11"), ex);
        }
        return keyStore;
    }

    private KeyStore getKeyStoreFromDrivers() {
        KeyStoreLoaderException error = new KeyStoreLoaderException(coreMessagesBundle.getString("error.no.driver.compatible"));
        Map<String, String> drivers = DriverManager.getInstance().getDrivers();
        if (drivers == null || drivers.isEmpty()) {
            throw new DriverNotAvailableException(coreMessagesBundle.getString("error.driver.empity"));
        }
        Set<String> keyDrivers = drivers.keySet();
        KeyStore keyStore = null;
        for (String driver : keyDrivers) {
            try {
                String urlDriver = drivers.get(driver);
                Optional<ByteArrayInputStream> createConfig = this.createConfig(driver, urlDriver);
                if (!createConfig.isPresent()) continue;
                keyStore = this.getKeyStoreFromDriver(createConfig.get());
                break;
            }
            catch (IOException | PKCS11Exception | PKCS11NotFoundException e) {
                error.addError(e);
            }
            catch (InvalidPinException e) {
                throw e;
            }
        }
        if (keyStore == null && !error.hasErrors()) {
            Throwable t = new Throwable(coreMessagesBundle.getString("error.load.module.pcks11"));
            error.addError(t);
        }
        if (keyStore == null && error.hasErrors()) {
            error.printStackTrace();
            throw error;
        }
        return keyStore;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callback) {
        this.callback = callback;
    }

    private void removeProviderPKCS11() {
        if (lastPkcs11Provider != null && !"".equals(lastPkcs11Provider)) {
            System.out.println("Removendo o provider:" + lastPkcs11Provider);
            try {
                Provider provider = Security.getProvider(lastPkcs11Provider);
                if (provider != null) {
                    PKCS11 pkcs11 = PKCS11.getInstance(((SunPKCS11)provider).getProperty(lastPkcs11Provider), null, null, true);
                    pkcs11.C_Finalize(PKCS11Constants.NULL_PTR);
                }
                Security.removeProvider(lastPkcs11Provider);
            }
            catch (IOException | PKCS11Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private OptionalLong getSlot() throws IOException, PKCS11Exception {
        return this.getSlot(lastDriverPath);
    }

    private OptionalLong getSlot(String lastDriverPath) throws IOException, PKCS11Exception {
        PKCS11 pkcs11 = PKCS11.getInstance(lastDriverPath, "C_GetFunctionList", null, false);
        long[] slots = pkcs11.C_GetSlotList(true);
        if (slots.length > 0) {
            return OptionalLong.of(slots[0]);
        }
        return OptionalLong.empty();
    }

    private InputStream createConfig(long slot, String libraryPath) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("name = Pkcs11Accelerator\r\nlibrary = ");
        buffer.append(libraryPath);
        buffer.append("\r\nslot = ");
        buffer.append(slot);
        buffer.append("\r\n");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    public Optional<InputStream> createConfig() throws IOException, PKCS11Exception {
        OptionalLong slot = this.getSlot();
        if (!slot.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.createConfig(slot.getAsLong(), lastDriverPath));
    }

    public Optional<ByteArrayInputStream> createConfig(String name, String libraryPath) throws IOException, PKCS11Exception {
        OptionalLong slot = this.getSlot(libraryPath);
        if (!slot.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.createConfig(name, libraryPath, slot.getAsLong()));
    }

    private ByteArrayInputStream createConfig(String name, String libraryPath, long slot) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("name = ");
        buffer.append(name);
        buffer.append("\r\nlibrary = ");
        buffer.append(libraryPath);
        buffer.append("\r\nslot = ");
        buffer.append(slot);
        buffer.append("\r\n");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    public static long[] getSlotsWithTokens(String libraryPath) throws IOException {
        CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
        String functionList = "C_GetFunctionList";
        initArgs.flags = 0L;
        PKCS11 tmpPKCS11 = null;
        long[] slotList = null;
        try {
            try {
                tmpPKCS11 = PKCS11.getInstance(libraryPath, functionList, initArgs, false);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (PKCS11Exception e) {
            try {
                initArgs = null;
                tmpPKCS11 = PKCS11.getInstance(libraryPath, functionList, initArgs, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (PKCS11Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            for (long slot : slotList = tmpPKCS11.C_GetSlotList(true)) {
                CK_TOKEN_INFO tokenInfo = tmpPKCS11.C_GetTokenInfo(slot);
                System.out.println("slot: " + slot + "\nmanufacturerID: " + String.valueOf(tokenInfo.manufacturerID) + "\nmodel: " + String.valueOf(tokenInfo.model));
            }
        }
        catch (PKCS11Exception ex) {
            ex.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return slotList;
    }

    public void tokenInfo(PKCS11 pkcs11, long slot) throws PKCS11Exception {
        CK_TOKEN_INFO tokenInfo = pkcs11.C_GetTokenInfo(slot);
        System.out.println("slot: " + slot + "\nmanufacturerID: " + String.valueOf(tokenInfo.manufacturerID) + "\nmodel: " + String.valueOf(tokenInfo.model));
    }
}

