/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.core.util;

import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import x2br.security.signer.core.util.CertificateUtilException;
import x2br.security.signer.core.util.MessagesBundle;

public class OIDExtensionUtil {
    private final X509Certificate x509;
    private final Map<String, String> oid_2_5_29_17;
    private final Map<String, String> oid_2_5_29_31;
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public OIDExtensionUtil(X509Certificate x509) {
        this.x509 = x509;
        this.oid_2_5_29_17 = new HashMap<String, String>();
        this.oid_2_5_29_31 = new HashMap<String, String>();
        this.process_2_5_29_17();
        this.process_2_5_29_31();
    }

    private void process_2_5_29_17() {
        byte[] extension = this.x509.getExtensionValue("2.5.29.17");
        int extLength = extension.length;
        int extIndex = 0;
        byte thisOIDLen = 0;
        if (extension[6] == -96 || extension[6] == -127) {
            extIndex = 6;
        } else if (extension[5] == -96 || extension[5] == -127) {
            extIndex = 5;
        } else if (extension[4] == -96 || extension[5] == -127) {
            extIndex = 4;
        } else {
            return;
        }
        while (extIndex < extLength) {
            if (extension[extIndex] == -96) {
                thisOIDLen = extension[extIndex + 1];
                String oidThird = Integer.toString(extension[extIndex + 5]);
                String oidForth = Integer.toString(extension[extIndex + 6]);
                String oidFifth = Integer.toString(extension[extIndex + 7]);
                String oidSixth = Integer.toString(extension[extIndex + 8]);
                String thisOIDId = new String("2.16." + oidThird + "." + oidForth + "." + oidFifth + "." + oidSixth);
                int thisOIDStart = 0;
                byte thisOIDDataLen = 0;
                if (extension[extIndex + 9] == -96) {
                    thisOIDDataLen = extension[extIndex + 12];
                    thisOIDStart = extIndex + 13;
                } else if (extension[extIndex + 9] == -126) {
                    thisOIDDataLen = extension[extIndex + 17];
                    thisOIDStart = extIndex + 18;
                } else {
                    extIndex += thisOIDLen + 2;
                    break;
                }
                String thisOIDData = "";
                try {
                    thisOIDData = new String(extension, thisOIDStart, (int)thisOIDDataLen, "ISO8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CertificateUtilException(coreMessagesBundle.getString("error.encoding.oid", "2.5.29.17"), e);
                }
                this.oid_2_5_29_17.put(thisOIDId, thisOIDData);
                extIndex += thisOIDLen + 2;
                continue;
            }
            if (extension[extIndex] == -127) {
                String thisRFCId = new String("RFC822");
                byte thisRFCDataLen = extension[extIndex + 1];
                String thisRFCData = "";
                try {
                    thisRFCData = new String(extension, extIndex + 2, (int)thisRFCDataLen, "ISO8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CertificateUtilException(coreMessagesBundle.getString("error.encoding.oid", "2.5.29.17"), e);
                }
                this.oid_2_5_29_17.put(thisRFCId, thisRFCData);
                extIndex += thisRFCDataLen + 2;
                continue;
            }
            extIndex = extLength;
        }
    }

    private void process_2_5_29_31() {
        int extIndex;
        byte[] extension = this.x509.getExtensionValue("2.5.29.31");
        if (extension[extIndex = 10] == -122) {
            String thisOIDId = new String("2.5.29.31");
            byte thisOIDDataLen = extension[extIndex + 1];
            String thisOIDData = "";
            try {
                thisOIDData = new String(extension, extIndex + 2, (int)thisOIDDataLen, "ISO8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new CertificateUtilException(coreMessagesBundle.getString("error.encoding.oid", "2.5.29.31"), e);
            }
            this.oid_2_5_29_31.put(thisOIDId, thisOIDData);
        }
    }

    public String getValue(String key) {
        if (key.equals("2.5.29.31")) {
            return this.oid_2_5_29_31.get(key);
        }
        return this.oid_2_5_29_17.get(key);
    }

    public String getValue(String key, int beginIndex) {
        String value = this.getValue(key);
        if (value != null) {
            return value.substring(beginIndex);
        }
        return null;
    }

    public String getValue(String key, int beginIndex, int endIndex) {
        String value = this.getValue(key);
        if (value != null) {
            return value.substring(beginIndex, endIndex);
        }
        return null;
    }
}

