/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.factory;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.signer.KeyStoreLoader;
import x2br.security.signer.KeyStoreLoaderException;
import x2br.security.signer.core.DriverKeyStoreLoader;
import x2br.security.signer.core.FileSystemKeyStoreLoader;
import x2br.security.signer.core.MSKeyStoreLoader;
import x2br.security.signer.core.pkcs11.DriverManager;
import x2br.security.signer.core.util.MessagesBundle;

public class KeyStoreLoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreLoaderFactory.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public static KeyStoreLoader factoryKeyStoreLoader() {
        logger.debug(coreMessagesBundle.getString("info.keystore.no.parameter"));
        if (DriverManager.getInstance().getSO().toLowerCase().indexOf("indows") > 0) {
            logger.debug(coreMessagesBundle.getString("info.keystore.ms"));
            if (DriverManager.getInstance().isMSCapiDisabled() || !DriverManager.isMSCAPI_ON()) {
                logger.debug(coreMessagesBundle.getString("info.keystore.ms.pkcs11"));
                return new DriverKeyStoreLoader();
            }
            logger.debug(coreMessagesBundle.getString("info.keystore.mscapi"));
            return new MSKeyStoreLoader();
        }
        logger.debug(coreMessagesBundle.getString("info.keystore.pkcs11"));
        return new DriverKeyStoreLoader();
    }

    public static KeyStoreLoader factoryKeyStoreLoader(File file) {
        return new FileSystemKeyStoreLoader(file);
    }

    public static KeyStoreLoader factoryKeyStoreLoader(Class<? extends KeyStoreLoader> clazz) {
        if (clazz == null) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.parm.clazz.null"));
        }
        KeyStoreLoader result = null;
        try {
            result = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.class.instance", clazz.getCanonicalName()));
        }
        return result;
    }
}

