/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.pkcs11;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import x2br.security.certificate.BasicCertificate;
import x2br.security.certificate.ICPBRCertificatePF;
import x2br.security.signer.CertificateValidatorException;
import x2br.security.signer.DriverNotAvailableException;
import x2br.security.signer.InvalidPinException;
import x2br.security.signer.KeyStoreLoader;
import x2br.security.signer.KeyStoreLoaderException;
import x2br.security.signer.PKCS11NotFoundException;
import x2br.security.signer.factory.KeyStoreLoaderFactory;
import x2br.security.signer.pkcs11.FrameConfig;
import x2br.security.signer.ui.PinCallbackHandler;
import x2br.security.signer.ui.model.Message;

public class TokenLogin {
    KeyStore keystore = null;

    public void reloadKeystore() {
        while (this.keystore == null) {
            this.keystore = this.getKeyStore();
        }
    }

    public Message toJson() {
        Message msg = new Message();
        Message.Data data = null;
        Message.Error msgError = null;
        try {
            this.reloadKeystore();
            Enumeration<String> aliasesEnum = this.keystore.aliases();
            String alias = "";
            data = new Message.Data();
            while (aliasesEnum.hasMoreElements()) {
                alias = aliasesEnum.nextElement();
                try {
                    X509Certificate cert0 = (X509Certificate)this.keystore.getCertificate(alias.toString());
                    BasicCertificate ce = new BasicCertificate(cert0);
                    if (!ce.hasCertificatePF()) continue;
                    ICPBRCertificatePF ippBRCertificatePF = ce.getICPBRCertificatePF();
                    Message.Certificate cert = new Message.Certificate(ce.getCertificateIssuerDN().toString(), ce.getSerialNumber(), ce.getNome(), ippBRCertificatePF.getCPF(), ce.getEmail(), new Message.Validate(ce.getBeforeDate(), ce.getAfterDate()));
                    data.addCerts(cert);
                }
                catch (IOException | KeyStoreException exception) {}
            }
        }
        catch (DriverNotAvailableException e) {
            msgError = new Message.Error("400", FrameConfig.MESSAGE_ERROR_PKCS11_NOT_FOUND.getValue());
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_DRIVER_NOT_AVAILABLE.getValue());
        }
        catch (PKCS11NotFoundException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_PKCS11_NOT_FOUND.getValue());
            msgError = new Message.Error("400", FrameConfig.MESSAGE_ERROR_PKCS11_NOT_FOUND.getValue());
        }
        catch (CertificateValidatorException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_LOAD_TOKEN.getValue());
            msgError = new Message.Error("401", FrameConfig.MESSAGE_ERROR_LOAD_TOKEN.getValue());
        }
        catch (InvalidPinException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_INVALID_PIN.getValue());
            msgError = new Message.Error("401", FrameConfig.MESSAGE_ERROR_INVALID_PIN.getValue());
        }
        catch (KeyStoreLoaderException ke) {
            this.showFailDialog(ke.getMessage());
        }
        catch (KeyStoreException ex) {
            msgError = new Message.Error("404", FrameConfig.MESSAGE_ERROR_UNEXPECTED.getValue());
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_UNEXPECTED.getValue());
        }
        msg.setData(data);
        msg.setError(msgError);
        this.keystore = null;
        return msg;
    }

    public KeyStore getKeyStore() {
        try {
            KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader();
            loader.setCallbackHandler(new PinCallbackHandler());
            this.keystore = loader.getKeyStore();
            return this.keystore;
        }
        catch (DriverNotAvailableException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_DRIVER_NOT_AVAILABLE.getValue());
        }
        catch (PKCS11NotFoundException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_PKCS11_NOT_FOUND.getValue());
        }
        catch (CertificateValidatorException e) {
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_LOAD_TOKEN.getValue());
        }
        catch (InvalidPinException e) {
            this.showFailDialog(e.getLocalizedMessage());
        }
        catch (KeyStoreLoaderException ke) {
            this.showFailDialog(ke.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showFailDialog(FrameConfig.MESSAGE_ERROR_UNEXPECTED.getValue());
        }
        return null;
    }

    private void showFailDialog(String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, FrameConfig.LABEL_DIALOG_OPTION_PANE_TITLE.getValue(), 0);
    }

    public static void main(String[] args) {
        TokenLogin tokenLogin = new TokenLogin();
        Message json = tokenLogin.toJson();
        System.out.println("Message:" + json);
    }
}

