/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.pkcs11.qua;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import x2br.security.signer.pkcs11.qua.PKCS11HelperException;

public class PKCS11Helper {
    private static int MAX_CERTS = 1000;
    private static long CKM_RSA_PKCS = 1L;
    private static long CKM_SHA1_RSA_PKCS = 6L;
    String _initArgs;
    String _pk11LibPath;
    String _name;
    Vector<X509Certificate> certificates = new Vector();

    public PKCS11Helper(String pk11LibPath, String initArgs) throws PKCS11HelperException {
        this._initArgs = initArgs;
        this._pk11LibPath = pk11LibPath;
        this.initialize();
    }

    public PKCS11Helper(String pk11LibPath) throws PKCS11HelperException {
        this._initArgs = null;
        this._pk11LibPath = pk11LibPath;
        this.initialize();
    }

    public String getName() {
        return this._name;
    }

    private void initialize() throws PKCS11HelperException {
        long[] slots;
        long hSession = 0L;
        boolean found = false;
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE attr = new CK_ATTRIBUTE();
        CK_TOKEN_INFO ckti = null;
        PKCS11 p11 = this.getP11Instance();
        try {
            slots = p11.C_GetSlotList(true);
        }
        catch (Exception e) {
            throw new PKCS11HelperException("Getting Slot List::" + e.getMessage(), PKCS11HelperException.errorType.ERR_GET_SLOT_LIST);
        }
        for (long k : slots) {
            try {
                System.out.println("Slot k = " + k);
                for (long x : p11.C_GetMechanismList(k)) {
                    if (x != CKM_RSA_PKCS && x != CKM_SHA1_RSA_PKCS) continue;
                    System.out.println("Slot " + k + " has signature capabilities");
                    break;
                }
                ckti = p11.C_GetTokenInfo(k);
                this._name = new String(ckti.label);
            }
            catch (Exception e) {
                throw new PKCS11HelperException("Getting token Info::" + e.getMessage(), PKCS11HelperException.errorType.ERR_GET_TOKEN_INFO);
            }
            try {
                hSession = p11.C_OpenSession(k, 4L, null, null);
            }
            catch (Exception e) {
                throw new PKCS11HelperException("Opening a new Session::" + e.getMessage(), PKCS11HelperException.errorType.ERR_OPEN_SESSION);
            }
            attr.type = 0L;
            attr.pValue = 1L;
            attrs[0] = attr;
            try {
                p11.C_FindObjectsInit(hSession, attrs);
                long[] l = p11.C_FindObjects(hSession, MAX_CERTS);
                p11.C_FindObjectsFinal(hSession);
                for (long i : l) {
                    CK_ATTRIBUTE attrPriv = new CK_ATTRIBUTE();
                    CK_ATTRIBUTE[] attrsP = new CK_ATTRIBUTE[2];
                    attrPriv.type = 0L;
                    attrPriv.pValue = 2L;
                    attr.type = 258L;
                    attr.pValue = this.getID(hSession, i, p11);
                    if (attr.pValue == null) continue;
                    attrsP[0] = attrPriv;
                    attrsP[1] = attr;
                    p11.C_FindObjectsInit(hSession, attrsP);
                    long[] m = p11.C_FindObjects(hSession, MAX_CERTS);
                    if (m.length > 0) {
                        found = true;
                        this.certificates.add(this.loadCert(hSession, i, p11));
                    }
                    p11.C_FindObjectsFinal(hSession);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PKCS11HelperException("Unsuccesfully FindObjects secuence::" + e.getMessage(), PKCS11HelperException.errorType.ERR_FIND_OBJECTS);
            }
            try {
                p11.C_CloseSession(hSession);
                if (!found) continue;
                break;
            }
            catch (Throwable e) {
                throw new PKCS11HelperException("Cannot close sesion::" + e.getMessage(), PKCS11HelperException.errorType.ERR_CLOSE_SESSION);
            }
        }
        try {
            p11 = null;
            Runtime.getRuntime().gc();
        }
        catch (Throwable e) {
            throw new PKCS11HelperException("Cannot Finalize::" + e.getMessage(), PKCS11HelperException.errorType.ERR_FINALIZE);
        }
    }

    private X509Certificate loadCert(long session, long oHandle, PKCS11 p11) throws PKCS11Exception, CertificateException {
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        p11.C_GetAttributeValue(session, oHandle, attrs);
        byte[] bytes = attrs[0].getByteArray();
        if (bytes == null) {
            throw new CertificateException("unexpectedly retrieved null byte array");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
    }

    private byte[] getID(long session, long oHandle, PKCS11 p11) throws PKCS11Exception, CertificateException {
        byte[] bytes = null;
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        p11.C_GetAttributeValue(session, oHandle, attrs);
        if (attrs[0].pValue != null) {
            bytes = attrs[0].getByteArray();
        }
        return bytes;
    }

    public X509Certificate[] getCertificates() throws PKCS11HelperException {
        X509Certificate[] xcer = new X509Certificate[]{};
        return this.certificates.toArray(xcer);
    }

    public long[] getSignatureCapableSlots() throws PKCS11HelperException {
        long[] slots;
        Vector<Long> vslots = new Vector<Long>();
        PKCS11 p11 = this.getP11Instance();
        try {
            slots = p11.C_GetSlotList(true);
        }
        catch (Exception e) {
            throw new PKCS11HelperException("Getting Slot List::" + e.getMessage(), PKCS11HelperException.errorType.ERR_GET_SLOT_LIST);
        }
        block4: for (long k : slots) {
            try {
                for (long x : p11.C_GetMechanismList(k)) {
                    if (x != CKM_SHA1_RSA_PKCS) continue;
                    vslots.add(k);
                    continue block4;
                }
            }
            catch (PKCS11Exception e) {
                throw new PKCS11HelperException("Cannot get Mechanism list::" + e.getMessage(), PKCS11HelperException.errorType.ERR_GET_SLOT_LIST);
            }
        }
        long[] res = new long[vslots.size()];
        for (int i = 0; i < vslots.size(); ++i) {
            res[i] = (Long)vslots.get(i);
        }
        return res;
    }

    public PKCS11 getP11Instance() throws PKCS11HelperException {
        Method[] methods = PKCS11.class.getMethods();
        Method p11Getinstance = null;
        PKCS11 p11 = null;
        CK_C_INITIALIZE_ARGS cia = new CK_C_INITIALIZE_ARGS();
        cia.pReserved = this._initArgs;
        cia.flags = 0L;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("getInstance")) continue;
            p11Getinstance = methods[i];
        }
        try {
            File _fpk11LibPath = new File(this._pk11LibPath);
            this._pk11LibPath = _fpk11LibPath.getCanonicalPath();
            String version = System.getProperty("java.version");
            p11 = version.indexOf("1.5") > -1 ? (PKCS11)p11Getinstance.invoke(null, this._pk11LibPath, cia, false) : (PKCS11)p11Getinstance.invoke(null, this._pk11LibPath, "C_GetFunctionList", cia, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PKCS11HelperException("Problem using java reflection with pkcs11 classes::" + e.getMessage(), PKCS11HelperException.errorType.ERR_INVOKE_INITIALIZE);
        }
        return p11;
    }

    public static void main(String[] args) throws PKCS11HelperException {
        PKCS11Helper pk11h = new PKCS11Helper("/usr/lib/libclauerpkcs11.so", "");
        for (X509Certificate xc : pk11h.getCertificates()) {
            System.out.println(xc.getSubjectDN());
        }
        for (long i : pk11h.getSignatureCapableSlots()) {
            System.out.println("Slot " + i + " is signature capable.");
        }
    }
}

