/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.ui.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Json {
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter()).create();

    public static Gson exec() {
        return gson;
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat;

        public DateTypeAdapter() {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm a z");
        }

        public DateTypeAdapter(String dateFormate, Locale locale) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz", locale);
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(this.dateFormat.format(date));
        }

        @Override
        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                return this.dateFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }
}

