/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLExt;
import jogamp.opengl.egl.EGLExtImpl;
import jogamp.opengl.egl.EGLExtProcAddressTable;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLContext
extends GLContextImpl {
    private boolean eglQueryStringInitialized;
    private boolean eglQueryStringAvailable;
    private EGLExt _eglExt;
    private EGLExtProcAddressTable eglExtProcAddressTable;

    EGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates(boolean bl) {
        this.eglQueryStringInitialized = false;
        this.eglQueryStringAvailable = false;
        this.eglExtProcAddressTable = null;
        super.resetStates(bl);
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getEGLExt();
    }

    public EGLExt getEGLExt() {
        if (this._eglExt == null) {
            this._eglExt = new EGLExtImpl(this);
        }
        return this._eglExt;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    public final EGLExtProcAddressTable getEGLExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        long l;
        if (EGL.eglGetCurrentContext() != this.contextHandle && !EGL.eglMakeCurrent(l = this.drawable.getNativeSurface().getDisplayHandle(), this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + EGLContext.toHexString(this.contextHandle) + " current on Thread " + EGLContext.getThreadName() + " with display " + EGLContext.toHexString(l) + ", drawableWrite " + EGLContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + EGLContext.toHexString(this.drawableRead.getHandle()) + " - Error code " + EGLContext.toHexString(EGL.eglGetError()) + ", " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!EGL.eglMakeCurrent(this.drawable.getNativeSurface().getDisplayHandle(), 0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context " + EGLContext.toHexString(this.contextHandle) + ": error code " + EGLContext.toHexString(EGL.eglGetError()));
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        this.destroyContextARBImpl(this.contextHandle);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        return 0L;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        int n;
        if (!EGL.eglDestroyContext(this.drawable.getNativeSurface().getDisplayHandle(), l) && 12288 != (n = EGL.eglGetError())) {
            throw new GLException("Error destroying OpenGL context " + EGLContext.toHexString(l) + ": error code " + EGLContext.toHexString(n));
        }
    }

    @Override
    protected boolean createImpl(long l) throws GLException {
        int n;
        int n2;
        long l2;
        GLProfile gLProfile;
        long l3;
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        block16: {
            eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
            l3 = eGLGraphicsConfiguration.getScreen().getDevice().getHandle();
            gLProfile = this.drawable.getGLProfile();
            l2 = eGLGraphicsConfiguration.getNativeConfig();
            if (0L == l3) {
                throw new GLException("Error: attempted to create an OpenGL context without a display connection");
            }
            if (0L == l2) {
                throw new GLException("Error: attempted to create an OpenGL context without a graphics configuration");
            }
            try {
                if (!EGL.eglBindAPI(12448)) {
                    throw new GLException("Caught: eglBindAPI to ES failed , error " + EGLContext.toHexString(EGL.eglGetError()));
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block16;
                gLException.printStackTrace();
            }
        }
        if (gLProfile.usesNativeGLES3()) {
            n2 = 3;
            n = GLRendererQuirks.existStickyDeviceQuirk(GLDrawableFactory.getEGLFactory().getDefaultDevice(), 15) ? 2 : 3;
        } else if (gLProfile.usesNativeGLES2()) {
            n2 = 2;
            n = 2;
        } else if (gLProfile.usesNativeGLES1()) {
            n2 = 1;
            n = 1;
        } else {
            throw new GLException("Error creating OpenGL context - invalid GLProfile: " + gLProfile);
        }
        int[] nArray = new int[]{12440, n, 12344};
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(nArray);
        this.contextHandle = EGL.eglCreateContext(l3, l2, l, intBuffer);
        if (this.contextHandle == 0L) {
            throw new GLException("Error creating OpenGL context: eglDisplay " + EGLContext.toHexString(l3) + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": Created OpenGL context 0x" + Long.toHexString(this.contextHandle) + ",\n\twrite surface 0x" + Long.toHexString(this.drawable.getHandle()) + ",\n\tread  surface 0x" + Long.toHexString(this.drawableRead.getHandle()) + ",\n\t" + this + ",\n\tsharing with 0x" + Long.toHexString(l));
        }
        if (!EGL.eglMakeCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + EGLContext.toHexString(this.contextHandle) + " current: error code " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (!this.setGLFunctionAvailability(true, n2, 0, 8, true, false)) {
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": createImpl: setGLFunctionAvailability FAILED delete " + EGLContext.toHexString(this.contextHandle));
            }
            EGL.eglMakeCurrent(this.drawable.getNativeSurface().getDisplayHandle(), 0L, 0L, 0L);
            EGL.eglDestroyContext(this.drawable.getNativeSurface().getDisplayHandle(), this.contextHandle);
            this.contextHandle = 0L;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "EGL-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": Initializing EGLextension address table: " + string);
        }
        this.eglQueryStringInitialized = false;
        this.eglQueryStringAvailable = false;
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.eglExtProcAddressTable = (EGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable reusing key(" + string + ") -> " + EGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.eglExtProcAddressTable = new EGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getEGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getEGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable mapping key(" + string + ") -> " + EGLContext.toHexString(this.getEGLExtProcAddressTable().hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.eglQueryStringInitialized) {
            this.eglQueryStringAvailable = this.getDrawableImpl().getGLDynamicLookupHelper().isFunctionAvailable("eglQueryString");
            this.eglQueryStringInitialized = true;
        }
        if (this.eglQueryStringAvailable) {
            String string = EGL.eglQueryString(this.drawable.getNativeSurface().getDisplayHandle(), 12373);
            if (DEBUG) {
                System.err.println("EGL extensions: " + string);
            }
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        if (this.hasRendererQuirk(2)) {
            return false;
        }
        return EGL.eglSwapInterval(this.drawable.getNativeSurface().getDisplayHandle(), n);
    }

    void mapCurrentAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice) {
        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
    }

    int getContextOptions() {
        return this.ctxOptions;
    }

    static void mapStaticGLESVersion(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int[] nArray = new int[2];
        GLContext.getRequestMajorAndCompat(gLProfile, nArray);
        if (gLProfile.isGLES()) {
            if (nArray[0] >= 3) {
                nArray[1] = nArray[1] | 0x1C00;
            } else if (nArray[0] >= 2) {
                nArray[1] = nArray[1] | 0x1400;
            }
        }
        if (!gLCapabilitiesImmutable.getHardwareAccelerated()) {
            nArray[1] = nArray[1] | 0x40;
        }
        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, nArray[0], 0, nArray[1]);
    }

    static void mapStaticGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        if (0 != (n3 & 8)) {
            EGLContext.mapStaticGLVersion(abstractGraphicsDevice, n, n, n2, n3);
            if (3 == n) {
                EGLContext.mapStaticGLVersion(abstractGraphicsDevice, 2, n, n2, n3);
            }
        }
    }

    private static void mapStaticGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3, int n4) {
        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, 8, n2, n3, n4);
        if (!(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(abstractGraphicsDevice.getHandle(), 0L, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), null);
            GLContext.mapAvailableGLVersion(eGLGraphicsDevice, n, 8, n2, n3, n4);
        }
    }

    protected static String getGLVersion(int n, int n2, int n3, String string) {
        return GLContext.getGLVersion(n, n2, n3, string);
    }

    protected static boolean getAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
    }

    protected static void setAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
    }

    protected static String toHexString(int n) {
        return GLContext.toHexString(n);
    }

    protected static String toHexString(long l) {
        return GLContext.toHexString(l);
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        throw new GLException("Not yet implemented");
    }

    @Override
    public final ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Should not call this");
    }

    @Override
    public final void glFreeMemoryNV(ByteBuffer byteBuffer) {
        throw new GLException("Should not call this");
    }
}

