/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import mp.mprj.webdesktop.Version;
import mprj.webdesktop.resources.Resources;

public class AboutDialog
extends JDialog {
    public AboutDialog(Frame owner) {
        super(owner, "Sobre MPRJ WebDesktop", true);
        this.initContent();
        this.initKeyStroke();
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(2);
    }

    private void initContent() {
        JLabel icon = new JLabel();
        icon.setIcon(Resources.getIcon("jxbrowser32x32.png"));
        JLabel appName = new JLabel(Version.getName());
        JLabel version = new JLabel("Vers\u00e3o: " + Version.getVersion());
        JLabel company = new JLabel("\u00a9 " + Calendar.getInstance().get(1) + " GSI-MPRJ.");
        JLabel rights = new JLabel("Todos os direitos reservados.");
        icon.setAlignmentX(0.5f);
        appName.setAlignmentX(0.5f);
        appName.setFont(appName.getFont().deriveFont(1));
        version.setAlignmentX(0.5f);
        company.setAlignmentX(0.5f);
        rights.setAlignmentX(0.5f);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(30, 70, 30, 70));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(icon);
        contentPane.add(Box.createVerticalStrut(16));
        contentPane.add(appName);
        contentPane.add(Box.createVerticalStrut(8));
        contentPane.add(version);
        contentPane.add(Box.createVerticalStrut(8));
        contentPane.add(company);
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add(rights);
        this.setContentPane(contentPane);
    }

    private void initKeyStroke() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    AboutDialog.this.dispose();
                }
            }
        });
        JRootPane rootPane = this.getRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        rootPane.getInputMap(2).put(keyStroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
    }
}

