/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    public static CefApp self = null;
    public static CefAppHandler appHandler_ = null;
    public static CefAppState state_ = CefAppState.NONE;
    public Timer workTimer_ = null;
    public HashSet<CefClient> clients_ = new HashSet();
    public CefSettings settings_ = null;

    public CefApp(String[] stringArray, CefSettings cefSettings) throws UnsatisfiedLinkError {
        super(stringArray);
        if (cefSettings != null) {
            this.settings_ = cefSettings.clone();
        }
        if (OS.isWindows()) {
            System.loadLibrary("jawt");
            System.loadLibrary("chrome_elf");
            System.loadLibrary("libcef");
        } else if (OS.isLinux()) {
            System.loadLibrary("cef");
        }
        System.loadLibrary("jcef");
        if (appHandler_ == null) {
            appHandler_ = this;
        }
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!CefApp.this.N_PreInitialize()) {
                        throw new IllegalStateException("Failed to pre-initialize native code");
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addAppHandler(CefAppHandler cefAppHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = cefAppHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] stringArray) throws UnsatisfiedLinkError {
        return CefApp.getInstance(stringArray, null);
    }

    public static synchronized CefApp getInstance(CefSettings cefSettings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, cefSettings);
    }

    public static synchronized CefApp getInstance(String[] stringArray, CefSettings cefSettings) throws UnsatisfiedLinkError {
        if (cefSettings != null && CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            self = new CefApp(stringArray, cefSettings);
            CefApp.setState(CefAppState.NEW);
        }
        return self;
    }

    public void setSettings(CefSettings cefSettings) throws IllegalStateException {
        if (CefApp.getState() != CefAppState.NONE && CefApp.getState() != CefAppState.NEW) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time.");
        }
        this.settings_ = cefSettings.clone();
    }

    public CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CefAppState getState() {
        CefAppState cefAppState = state_;
        synchronized (cefAppState) {
            return state_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setState(final CefAppState cefAppState) {
        CefAppState cefAppState2 = state_;
        synchronized (cefAppState2) {
            state_ = cefAppState;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (appHandler_ != null) {
                    appHandler_.stateHasChanged(cefAppState);
                }
            }
        });
    }

    public synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.shutdown();
                    break;
                }
                HashSet<CefClient> hashSet = new HashSet<CefClient>(this.clients_);
                for (CefClient cefClient : hashSet) {
                    cefClient.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.INITIALIZING);
                this.initialize();
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefClient cefClient = new CefClient();
                this.clients_.add(cefClient);
                return cefClient;
            }
        }
        throw new IllegalStateException("Can't crate client in state " + (Object)((Object)state_));
    }

    public boolean registerSchemeHandlerFactory(String string, String string2, CefSchemeHandlerFactory cefSchemeHandlerFactory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(string, string2, cefSchemeHandlerFactory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized void clientWasDisposed(CefClient cefClient) {
        this.clients_.remove(cefClient);
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.shutdown();
        }
    }

    public void initialize() {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CefSettings cefSettings;
                    String string = CefApp.this.getJcefLibPath();
                    System.out.println("initialize on " + Thread.currentThread() + " with library path " + string);
                    CefSettings cefSettings2 = cefSettings = CefApp.this.settings_ != null ? CefApp.this.settings_ : new CefSettings();
                    if (OS.isMacintosh()) {
                        if (cefSettings.browser_subprocess_path == null) {
                            Path path = Paths.get(string, "../Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
                            cefSettings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
                        }
                    } else if (OS.isWindows()) {
                        if (cefSettings.browser_subprocess_path == null) {
                            cefSettings.browser_subprocess_path = string + "\\jcef_helper.exe";
                        }
                    } else if (OS.isLinux()) {
                        if (cefSettings.browser_subprocess_path == null) {
                            cefSettings.browser_subprocess_path = string + "/jcef_helper";
                        }
                        if (cefSettings.resources_dir_path == null) {
                            cefSettings.resources_dir_path = string;
                        }
                        if (cefSettings.locales_dir_path == null) {
                            cefSettings.locales_dir_path = string + "/locales";
                        }
                    }
                    if (CefApp.this.N_Initialize(string, appHandler_, cefSettings)) {
                        CefApp.setState(CefAppState.INITIALIZED);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleBeforeTerminate() {
        System.out.println("Cmd+Q termination request.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler cefAppHandler = (CefAppHandler)(appHandler_ == null ? this : appHandler_);
                if (!cefAppHandler.onBeforeTerminate()) {
                    CefApp.this.dispose();
                }
            }
        });
    }

    public void shutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("shutdown on " + Thread.currentThread());
                CefApp.this.N_Shutdown();
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
        });
    }

    public void doMessageLoopWork(final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.getState() == CefAppState.TERMINATED) {
                    return;
                }
                final long l3 = 33L;
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (l <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(l3);
                } else {
                    long l2 = l;
                    if (l2 > l3) {
                        l2 = l3;
                    }
                    CefApp.this.workTimer_ = new Timer((int)l2, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(l3);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public String getJcefLibPath() {
        String[] stringArray;
        String string = System.getProperty("java.library.path");
        for (String string2 : stringArray = string.split(System.getProperty("path.separator"))) {
            File file = new File(string2);
            String[] stringArray2 = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.equalsIgnoreCase("libjcef.dylib") || string.equalsIgnoreCase("libjcef.so") || string.equalsIgnoreCase("jcef.dll");
                }
            });
            if (stringArray2 == null || stringArray2.length == 0) continue;
            return string2;
        }
        return string;
    }

    public native boolean N_PreInitialize();

    public native boolean N_Initialize(String var1, CefAppHandler var2, CefSettings var3);

    public native void N_Shutdown();

    public native void N_DoMessageLoopWork();

    public native CefVersion N_GetVersion();

    public native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    public native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public class CefVersion {
        public int JCEF_COMMIT_NUMBER;
        public int CEF_VERSION_MAJOR;
        public int CEF_COMMIT_NUMBER;
        public int CHROME_VERSION_MAJOR;
        public int CHROME_VERSION_MINOR;
        public int CHROME_VERSION_BUILD;
        public int CHROME_VERSION_PATCH;

        public CefVersion(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.JCEF_COMMIT_NUMBER = n;
            this.CEF_VERSION_MAJOR = n2;
            this.CEF_COMMIT_NUMBER = n3;
            this.CHROME_VERSION_MAJOR = n4;
            this.CHROME_VERSION_MINOR = n5;
            this.CHROME_VERSION_BUILD = n6;
            this.CHROME_VERSION_PATCH = n7;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CHROME_VERSION_BUILD + "." + this.JCEF_COMMIT_NUMBER;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CHROME_VERSION_BUILD + "." + this.CEF_COMMIT_NUMBER;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

