/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cef.network.CefPostData;
import org.cef.network.CefRequest_N;

public abstract class CefRequest {
    CefRequest() {
    }

    public static CefRequest create() {
        return CefRequest_N.createNative();
    }

    public abstract long getIdentifier();

    public abstract boolean isReadOnly();

    public abstract String getURL();

    public abstract void setURL(String var1);

    public abstract String getMethod();

    public abstract void setMethod(String var1);

    public abstract void setReferrer(String var1, ReferrerPolicy var2);

    public abstract String getReferrerURL();

    public abstract ReferrerPolicy getReferrerPolicy();

    public abstract CefPostData getPostData();

    public abstract void setPostData(CefPostData var1);

    public abstract void getHeaderMap(Map<String, String> var1);

    public abstract void setHeaderMap(Map<String, String> var1);

    public abstract void set(String var1, String var2, CefPostData var3, Map<String, String> var4);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public abstract String getFirstPartyForCookies();

    public abstract void setFirstPartyForCookies(String var1);

    public abstract ResourceType getResourceType();

    public abstract TransitionType getTransitionType();

    public String toString() {
        String string = "\nHTTP-Request";
        string = string + "\n  flags: " + this.getFlags();
        string = string + "\n  resourceType: " + (Object)((Object)this.getResourceType());
        string = string + "\n  transitionType: " + (Object)((Object)this.getTransitionType());
        string = string + "\n  firstPartyForCookies: " + this.getFirstPartyForCookies();
        string = string + "\n  referrerURL: " + this.getReferrerURL();
        string = string + "\n  referrerPolicy: " + (Object)((Object)this.getReferrerPolicy());
        string = string + "\n    " + this.getMethod() + " " + this.getURL() + " HTTP/1.1\n";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.getHeaderMap(hashMap);
        Set set = hashMap.entrySet();
        String string2 = null;
        for (Map.Entry entry : set) {
            String string3 = (String)entry.getKey();
            string = string + "    " + string3 + "=" + (String)entry.getValue() + "\n";
            if (!string3.equals("Content-Type")) continue;
            string2 = (String)entry.getValue();
        }
        CefPostData cefPostData = this.getPostData();
        if (cefPostData != null) {
            string = string + cefPostData.toString(string2);
        }
        return string;
    }

    public static enum ReferrerPolicy {
        REFERRER_POLICY_DEFAULT,
        REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_FROM_SECURE_TO_INSECURE,
        REFERRER_POLICY_REDUCE_REFERRER_GRANULARITY_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_ORIGIN_ONLY_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_NEVER_CLEAR_REFERRER,
        REFERRER_POLICY_ORIGIN,
        REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_ORIGIN_CLEAR_ON_TRANSITION_FROM_SECURE_TO_INSECURE,
        REFERRER_POLICY_NO_REFERRER,
        REFERRER_POLICY_LAST_VALUE;

    }

    public static enum TransitionFlags {
        TT_BLOCKED_FLAG(0x800000),
        TT_FORWARD_BACK_FLAG(0x1000000),
        TT_CHAIN_START_FLAG(0x10000000),
        TT_CHAIN_END_FLAG(0x20000000),
        TT_CLIENT_REDIRECT_FLAG(0x40000000),
        TT_SERVER_REDIRECT_FLAG(Integer.MIN_VALUE);

        public int flag;

        private TransitionFlags(int n2) {
            this.flag = n2;
        }

        public int getValue() {
            return this.flag;
        }
    }

    public static class CefUrlRequestFlags {
        public static int UR_FLAG_NONE = 0;
        public static int UR_FLAG_SKIP_CACHE = 1;
        public static int UR_FLAG_ALLOW_CACHED_CREDENTIALS = 2;
        public static int UR_FLAG_REPORT_UPLOAD_PROGRESS = 8;
        public static int UR_FLAG_REPORT_RAW_HEADERS = 32;
        public static int UR_FLAG_NO_DOWNLOAD_DATA = 64;
        public static int UR_FLAG_NO_RETRY_ON_5XX = 128;
    }

    public static enum TransitionType {
        TT_LINK(0),
        TT_EXPLICIT(1),
        TT_AUTO_SUBFRAME(3),
        TT_MANUAL_SUBFRAME(4),
        TT_FORM_SUBMIT(7),
        TT_RELOAD(8);

        public int value;

        private TransitionType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public int getSource() {
            return this.value & 0xFF;
        }

        public void addQualifier(TransitionFlags transitionFlags) {
            this.value |= transitionFlags.getValue();
        }

        public void addQualifiers(int n) {
            this.value |= n & 0xFFFFFF00;
        }

        public int getQualifiers() {
            return this.value & 0xFFFFFF00;
        }

        public void removeQualifier(TransitionFlags transitionFlags) {
            this.value &= ~transitionFlags.getValue();
        }

        public boolean isSet(TransitionFlags transitionFlags) {
            return (this.value & transitionFlags.getValue()) != 0;
        }

        public boolean isRedirect() {
            return (this.value & 0xC0000000) != 0;
        }
    }

    public static enum ResourceType {
        RT_MAIN_FRAME,
        RT_SUB_FRAME,
        RT_STYLESHEET,
        RT_SCRIPT,
        RT_IMAGE,
        RT_FONT_RESOURCE,
        RT_SUB_RESOURCE,
        RT_OBJECT,
        RT_MEDIA,
        RT_WORKER,
        RT_SHARED_WORKER,
        RT_PREFETCH,
        RT_FAVICON,
        RT_XHR,
        RT_PING,
        RT_SERVICE_WORKER;

    }
}

