/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture;

import org.panda_lang.panda.Panda;
import org.panda_lang.panda.framework.design.architecture.Environment;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.module.PrimitivePrototypeLiquid;
import org.panda_lang.panda.framework.design.architecture.prototype.registry.ClassPrototypeModelLoader;
import org.panda_lang.panda.framework.design.interpreter.PandaInterpreter;
import org.panda_lang.panda.framework.language.architecture.module.PandaModulePath;

public class PandaEnvironment
implements Environment {
    protected final Panda panda;
    protected final ModulePath modulePath;
    protected PandaInterpreter interpreter;

    public PandaEnvironment(Panda panda) {
        this.panda = panda;
        this.modulePath = new PandaModulePath();
    }

    public void initialize() {
        PrimitivePrototypeLiquid liquid = new PrimitivePrototypeLiquid();
        liquid.fill(this.modulePath);
        ClassPrototypeModelLoader modelLoader = new ClassPrototypeModelLoader(this.modulePath);
        this.panda.getPandaLanguage().getMappings().forEach(modelLoader::load);
        this.interpreter = PandaInterpreter.builder().environment(this).elements(this.panda.getPandaLanguage()).build();
    }

    @Override
    public ModulePath getModulePath() {
        return this.modulePath;
    }

    @Override
    public PandaInterpreter getInterpreter() {
        return this.interpreter;
    }
}

