/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.dynamic.accessor;

import org.panda_lang.panda.framework.design.architecture.dynamic.ExecutableStatement;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScopeInstance;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.value.StaticValue;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.architecture.value.PandaStaticValue;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class FieldAccessor
extends ExecutableStatement {
    private final PrototypeField field;
    private final Expression instanceExpression;
    private final Expression valueExpression;

    public FieldAccessor(Expression instanceExpression, PrototypeField field, Expression valueExpression) {
        this.instanceExpression = instanceExpression;
        this.field = field;
        this.valueExpression = valueExpression;
    }

    @Override
    public void execute(ExecutableBranch branch) {
        int internalPointer = this.field.getFieldIndex();
        if (internalPointer == -1) {
            throw new PandaRuntimeException("Invalid memory pointer, variable may not exist");
        }
        if (this.field.isStatic()) {
            StaticValue staticValue = PandaStaticValue.of(this.valueExpression.getExpressionValue(branch));
            if ((staticValue.getValue() == null || staticValue.getValue().isNull()) && !this.field.isNullable()) {
                throw new PandaRuntimeException("Cannot assign null to static field '" + this.field.getName() + "' without nullable modifier");
            }
            if (!this.field.isMutable() && this.field.getStaticValue() != null) {
                throw new PandaRuntimeException("Cannot change value of immutable static field '" + this.field.getName() + "'");
            }
            this.field.setStaticValue(staticValue);
            return;
        }
        Value instance = this.instanceExpression.getExpressionValue(branch);
        if (instance == null) {
            throw new PandaRuntimeException("Instance is not defined");
        }
        if (!(instance.getObject() instanceof ClassScopeInstance)) {
            throw new PandaRuntimeException("Cannot get field value of external object");
        }
        ClassScopeInstance pandaInstance = (ClassScopeInstance)instance.getObject();
        branch.instance(pandaInstance.toValue());
        Value value = this.valueExpression.getExpressionValue(branch);
        if (value.isNull() && !this.field.isNullable()) {
            throw new PandaRuntimeException("Cannot assign null to field  '" + this.field.getName() + "' without nullable modifier");
        }
        if (!this.field.isMutable() && pandaInstance.get(internalPointer) != null) {
            throw new PandaRuntimeException("Cannot change value of immutable field '" + this.field.getName() + "'");
        }
        pandaInstance.set(internalPointer, value);
    }

    public String toString() {
        return this.instanceExpression.getReturnType().getClassName() + "@f_memory[" + this.field.getFieldIndex() + "] << " + this.valueExpression;
    }
}

