/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.dynamic.accessor;

import org.panda_lang.panda.framework.design.architecture.dynamic.ExecutableStatement;
import org.panda_lang.panda.framework.design.architecture.dynamic.ScopeInstance;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.design.architecture.value.Variable;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class VariableAccessor
extends ExecutableStatement {
    private final Variable variable;
    private final int internalPointer;
    private final Expression expression;

    public VariableAccessor(Variable variable, int internalPointer, Expression expression) {
        this.variable = variable;
        this.internalPointer = internalPointer;
        this.expression = expression;
    }

    @Override
    public void execute(ExecutableBranch branch) {
        if (this.internalPointer == -1) {
            throw new PandaRuntimeException("Invalid memory pointer, variable may not exist");
        }
        Value value = this.expression.getExpressionValue(branch);
        ScopeInstance currentScope = branch.getCurrentScope();
        if (value == null) {
            throw new PandaRuntimeException("Cannot assign not existing value to variable '" + this.variable.getName() + "'");
        }
        if (value.isNull() && !this.variable.isNullable()) {
            throw new PandaRuntimeException("Cannot assign null to variable '" + this.variable.getName() + "' without nullable modifier");
        }
        if (!this.variable.isMutable() && currentScope.get(this.internalPointer) != null) {
            throw new PandaRuntimeException("Cannot change value of immutable variable '" + this.variable.getName() + "'");
        }
        currentScope.set(this.internalPointer, value);
    }

    public String toString() {
        return "'v_memory'[" + this.internalPointer + "] << " + this.expression;
    }
}

