/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.PandaClassPrototypeUtils;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PandaConstructors;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructors;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PandaFields;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeFields;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethods;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethods;
import org.panda_lang.panda.framework.design.architecture.value.StaticValue;
import org.panda_lang.panda.framework.language.architecture.value.PandaStaticValue;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class PandaClassPrototype
implements ClassPrototype {
    private final String className;
    private final Class<?> associated;
    private final Collection<String> aliases;
    private final Collection<ClassPrototype> extended;
    private final PrototypeConstructors constructors;
    private final PrototypeFields fields;
    private final PrototypeMethods methods;
    private boolean initialized;

    public PandaClassPrototype(String className, Class<?> associated, String ... aliases) {
        this.className = className;
        this.associated = associated;
        this.aliases = Arrays.asList(aliases);
        this.extended = new ArrayList<ClassPrototype>(1);
        this.constructors = new PandaConstructors();
        this.fields = new PandaFields();
        this.methods = new PandaMethods();
        this.initialized = false;
    }

    public PandaClassPrototype(Class<?> clazz, String ... aliases) {
        this(clazz.getSimpleName(), clazz, aliases);
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (PrototypeField prototypeField : this.fields.getListOfFields()) {
            if (!prototypeField.hasDefaultValue() || !prototypeField.isStatic()) continue;
            Expression expression = prototypeField.getDefaultValue();
            StaticValue staticValue = PandaStaticValue.of(expression.getExpressionValue(null));
            prototypeField.setStaticValue(staticValue);
        }
    }

    @Override
    public boolean isClassOf(String className) {
        if (this.getClassName().equals(className)) {
            return true;
        }
        if (this.associated != null && this.associated.getSimpleName().equals(className)) {
            return true;
        }
        for (String alias : this.getAliases()) {
            if (!alias.equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssociatedWith(ClassPrototype prototype) {
        return prototype != null && (prototype.equals(this) || PandaClassPrototypeUtils.isAssociatedWith(this.associated, prototype.getAssociated()) || PandaClassPrototypeUtils.hasCommonPrototypes(this.extended, prototype.getExtended()));
    }

    @Override
    public PrototypeMethods getMethods() {
        return this.methods;
    }

    @Override
    public PrototypeFields getFields() {
        return this.fields;
    }

    @Override
    public PrototypeConstructors getConstructors() {
        return this.constructors;
    }

    @Override
    public Collection<ClassPrototype> getExtended() {
        return this.extended;
    }

    @Override
    public Class<?> getAssociated() {
        return this.associated;
    }

    @Override
    public Collection<String> getAliases() {
        return this.aliases;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public int hashCode() {
        return Objects.hashCode(this.className);
    }

    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    public String toString() {
        return "ClassPrototype::" + this.className;
    }
}

