/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.constructor;

import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScope;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScopeInstance;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.ConstructorScope;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.ConstructorScopeInstance;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructor;
import org.panda_lang.panda.framework.design.architecture.prototype.parameter.ParameterUtils;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.architecture.value.PandaValue;
import org.panda_lang.panda.language.runtime.ExecutableBranch;

public class PandaConstructor
implements PrototypeConstructor {
    private final ClassPrototype classPrototype;
    private final ClassScope classScope;
    private final ConstructorScope constructorScope;
    private final ClassPrototype[] types;

    public PandaConstructor(ClassPrototype classPrototype, ClassScope classScope, ConstructorScope constructorScope) {
        this.classPrototype = classPrototype;
        this.classScope = classScope;
        this.constructorScope = constructorScope;
        this.types = ParameterUtils.toTypes(constructorScope.getParameters());
    }

    @Override
    public ClassScopeInstance createInstance(ExecutableBranch branch, Value ... values) {
        ClassScopeInstance classInstance = this.classScope.createInstance(branch);
        PandaValue instance = new PandaValue(this.classPrototype, classInstance);
        ConstructorScopeInstance constructorInstance = this.constructorScope.createInstance(branch);
        ParameterUtils.assignValues(constructorInstance, values);
        branch.instance(instance);
        branch.call(constructorInstance);
        return classInstance;
    }

    @Override
    public ClassPrototype[] getParameterTypes() {
        return this.types;
    }

    public ClassPrototype getClassPrototype() {
        return this.classPrototype;
    }
}

