/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.generator;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructor;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorManager;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.language.runtime.ExecutableBranch;

public class ClassPrototypeConstructorGenerator {
    private final ClassPrototypeGenerator generator;
    private final ModulePath modulePath;
    private final Constructor<?> constructor;

    public ClassPrototypeConstructorGenerator(ClassPrototypeGenerator generator, ModulePath modulePath, ClassPrototype prototype, Constructor<?> constructor) {
        this.generator = generator;
        this.modulePath = modulePath;
        this.constructor = constructor;
    }

    public PrototypeConstructor generate() {
        final ClassPrototype[] parameters = new ClassPrototype[this.constructor.getParameterCount()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.generator.computeIfAbsent(this.modulePath, this.constructor.getParameterTypes()[i]);
        }
        this.constructor.setAccessible(true);
        return new PrototypeConstructor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Object createInstance(ExecutableBranch bridge, Value ... values) {
                long start = System.nanoTime();
                try {
                    Object[] args = new Object[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        args[i] = values[i].getValue();
                    }
                    Object t = ClassPrototypeConstructorGenerator.this.constructor.newInstance(args);
                    return t;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ClassPrototypeGeneratorManager.reflectionsTime += System.nanoTime() - start;
                }
                return null;
            }

            @Override
            public ClassPrototype[] getParameterTypes() {
                return parameters;
            }
        };
    }
}

