/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.generator;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.PandaClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructor;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeConstructorGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeFieldGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeMethodGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethod;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;

public class ClassPrototypeGenerator {
    protected static long totalLoadTime;
    protected static boolean locked;

    public ClassPrototype generate(@Nullable ModulePath modulePath, Class<?> type) {
        Object prototypeField;
        Object generator;
        boolean bypass = !locked;
        long currentTime = System.nanoTime();
        if (bypass) {
            locked = true;
        }
        PandaClassPrototype prototype = new PandaClassPrototype(type.getSimpleName(), type, new String[0]);
        if (modulePath != null) {
            Module module = modulePath.create(type);
            module.add(prototype);
        }
        for (Field field : type.getFields()) {
            generator = new ClassPrototypeFieldGenerator(this, modulePath, prototype, field);
            prototypeField = ((ClassPrototypeFieldGenerator)generator).generate();
            prototype.getFields().addField((PrototypeField)prototypeField);
        }
        for (AccessibleObject accessibleObject : type.getConstructors()) {
            generator = new ClassPrototypeConstructorGenerator(this, modulePath, prototype, (Constructor<?>)accessibleObject);
            prototypeField = ((ClassPrototypeConstructorGenerator)generator).generate();
            prototype.getConstructors().addConstructor((PrototypeConstructor)prototypeField);
        }
        for (AccessibleObject accessibleObject : type.getMethods()) {
            generator = new ClassPrototypeMethodGenerator(this, modulePath, prototype, (Method)accessibleObject);
            PrototypeMethod prototypeMethod = ((ClassPrototypeMethodGenerator)generator).generate();
            prototype.getMethods().registerMethod(prototypeMethod);
        }
        if (bypass) {
            totalLoadTime += System.nanoTime() - currentTime;
            locked = false;
        }
        return prototype;
    }

    public ClassPrototype computeIfAbsent(ModulePath modulePath, Class<?> type) {
        ClassPrototype prototype;
        Module module = modulePath.get(type);
        ClassPrototype classPrototype = prototype = module == null || !module.hasClass(type) ? this.generate(modulePath, type) : module.get(type);
        if (prototype == null) {
            throw new PandaRuntimeException("Cannot prepare class: " + type);
        }
        module = modulePath.get(type);
        if (module == null) {
            throw new PandaRuntimeException("Cannot find module of prototype: " + prototype);
        }
        if (!module.hasClass(type)) {
            module.add(prototype);
        }
        return prototype;
    }

    public static void resetLoadTime() {
        totalLoadTime = 0L;
    }
}

