/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.method;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.dynamic.ExecutableStatement;
import org.panda_lang.panda.framework.design.architecture.dynamic.StandaloneExecutable;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethod;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionUtils;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class MethodInvoker
extends ExecutableStatement
implements StandaloneExecutable {
    private final PrototypeMethod method;
    private final Expression instanceExpression;
    private final Expression[] arguments;

    public MethodInvoker(PrototypeMethod method, @Nullable Expression instance, Expression[] arguments) {
        if (method == null) {
            throw new IllegalArgumentException("PrototypeMethod cannot be null");
        }
        this.method = method;
        this.instanceExpression = instance;
        this.arguments = arguments;
    }

    @Override
    public void execute(ExecutableBranch branch) {
        Value instance = null;
        if (this.instanceExpression != null) {
            instance = this.instanceExpression.getExpressionValue(branch);
            branch.instance(instance);
        }
        Value[] values = ExpressionUtils.getValues(branch, this.arguments);
        this.method.invoke(branch, instance != null ? instance.getObject() : null, values);
    }

    public PrototypeMethod getMethod() {
        return this.method;
    }
}

