/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.method;

import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethod;

public class PandaMethodBuilder {
    protected ClassPrototype prototype;
    protected String methodName;
    protected ClassPrototype[] parameterTypes;
    protected MethodVisibility visibility;
    protected ClassPrototype returnType;
    protected MethodCallback methodBody;
    protected boolean isStatic;
    protected boolean catchAllParameters;

    public PandaMethodBuilder prototype(ClassPrototype prototype) {
        this.prototype = prototype;
        return this;
    }

    public PandaMethodBuilder methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public PandaMethodBuilder parameterTypes(ModuleLoader moduleLoader, String ... parameterTypes) {
        ClassPrototype[] prototypes = new ClassPrototype[parameterTypes.length];
        for (int i = 0; i < prototypes.length; ++i) {
            prototypes[i] = moduleLoader.forClass(parameterTypes[i]);
        }
        this.parameterTypes = prototypes;
        return this;
    }

    public PandaMethodBuilder parameterTypes(ClassPrototype ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    public PandaMethodBuilder returnType(ClassPrototype returnType) {
        this.returnType = returnType;
        return this;
    }

    public PandaMethodBuilder visibility(MethodVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public PandaMethodBuilder methodBody(MethodCallback callback) {
        this.methodBody = callback;
        return this;
    }

    public PandaMethodBuilder catchAllParameters(boolean catchAllParameters) {
        this.catchAllParameters = catchAllParameters;
        return this;
    }

    public PandaMethodBuilder isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public PandaMethod build() {
        return new PandaMethod(this);
    }
}

