/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.interpreter.token;

import java.util.concurrent.atomic.AtomicInteger;

public class TokenType {
    private static final AtomicInteger ID_ASSIGNER = new AtomicInteger();
    public static final TokenType IDENTIFIER = new TokenType("IDENTIFIER");
    public static final TokenType LITERAL = new TokenType("LITERAL");
    public static final TokenType KEYWORD = new TokenType("KEYWORD");
    public static final TokenType SEPARATOR = new TokenType("SEPARATOR");
    public static final TokenType SEQUENCE = new TokenType("SEQUENCE");
    public static final TokenType OPERATOR = new TokenType("OPERATOR");
    public static final TokenType INDENTATION = new TokenType("INDENTATION");
    public static final TokenType UNKNOWN = new TokenType("UNKNOWN");
    private static final TokenType[] VALUES = new TokenType[8];
    private final int id = ID_ASSIGNER.getAndIncrement();
    private final String typeName;

    public TokenType(String typeName) {
        this.typeName = typeName;
    }

    public int ordinal() {
        return this.id;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenType)) {
            return false;
        }
        TokenType tokenType = (TokenType)o;
        return this.id == tokenType.id;
    }

    public String toString() {
        return this.getTypeName();
    }

    public static TokenType[] values() {
        return VALUES;
    }

    static {
        TokenType.VALUES[0] = IDENTIFIER;
        TokenType.VALUES[1] = LITERAL;
        TokenType.VALUES[2] = KEYWORD;
        TokenType.VALUES[3] = SEPARATOR;
        TokenType.VALUES[4] = SEQUENCE;
        TokenType.VALUES[5] = OPERATOR;
        TokenType.VALUES[6] = INDENTATION;
        TokenType.VALUES[7] = UNKNOWN;
    }
}

