/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.architecture;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.design.architecture.Script;
import org.panda_lang.panda.framework.design.architecture.statement.Statement;

public abstract class AbstractScript
implements Script {
    protected final String scriptName;
    protected final List<Statement> statements;

    public AbstractScript(String scriptName) {
        this.scriptName = scriptName;
        this.statements = new ArrayList<Statement>();
    }

    @Override
    public <T extends Statement> List<T> select(Class<? extends T> statementClass) {
        ArrayList<Statement> selectedStatements = new ArrayList<Statement>();
        for (Statement statement : this.statements) {
            if (!statementClass.isInstance(statement)) continue;
            Statement element = statement;
            selectedStatements.add(element);
        }
        return selectedStatements;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    public String toString() {
        StringBuilder node = new StringBuilder();
        node.append("'");
        node.append(this.getScriptName());
        node.append("': {");
        for (Statement statement : this.statements) {
            node.append(System.lineSeparator());
            node.append("  ");
            node.append(statement);
            node.append(",");
        }
        node.append(System.lineSeparator());
        node.append("}");
        return node.toString();
    }
}

