/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.messenger.translators;

import org.panda_lang.panda.framework.design.interpreter.Interpretation;
import org.panda_lang.panda.framework.design.interpreter.InterpreterFailure;
import org.panda_lang.panda.framework.design.interpreter.messenger.Messenger;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessage;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessageTranslator;
import org.panda_lang.panda.framework.language.interpreter.messenger.PandaMessengerMessage;
import org.panda_lang.panda.framework.language.interpreter.messenger.defaults.DefaultFailureTemplateBuilder;
import org.panda_lang.panda.framework.language.interpreter.messenger.defaults.DefaultMessageFormatter;
import org.panda_lang.panda.utilities.commons.redact.MessageFormatter;

public class InterpreterFailureTranslator
implements MessengerMessageTranslator<InterpreterFailure> {
    private final Interpretation interpretation;

    public InterpreterFailureTranslator(Interpretation interpretation) {
        this.interpretation = interpretation;
    }

    @Override
    public void handle(Messenger messenger, InterpreterFailure element) {
        this.interpretation.getFailures().add(element);
        MessageFormatter formatter = DefaultMessageFormatter.getFormatter().register("{{details}}", () -> DefaultFailureTemplateBuilder.indentation(element.getDetails()));
        DefaultFailureTemplateBuilder templateBuilder = new DefaultFailureTemplateBuilder().applyPlaceholders(formatter, element).includeCause().includeDetails(element.getDetails()).includeSource().includeMarker((Integer)formatter.getValue("{{index}}")).includeEnvironment().includeEnd();
        PandaMessengerMessage message = new PandaMessengerMessage(MessengerMessage.Level.FAILURE, templateBuilder.getAsLines(formatter, "InterpreterFailure"));
        messenger.sendMessage(message);
    }

    @Override
    public Class<InterpreterFailure> getType() {
        return InterpreterFailure.class;
    }
}

