/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.parser.generation.casual;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationUnit;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.PandaCasualParserGenerationUnit;

public class PandaCasualParserGenerationLayer
implements CasualParserGenerationLayer {
    private final List<CasualParserGenerationUnit> immediately = new ArrayList<CasualParserGenerationUnit>();
    private final List<CasualParserGenerationUnit> before = new ArrayList<CasualParserGenerationUnit>(1);
    private final List<CasualParserGenerationUnit> delegates = new ArrayList<CasualParserGenerationUnit>();
    private final List<CasualParserGenerationUnit> after = new ArrayList<CasualParserGenerationUnit>(1);

    @Override
    public void callImmediately(ParserData currentData, CasualParserGenerationLayer nextLayer) {
        this.call(this.immediately, currentData, nextLayer);
    }

    @Override
    public void call(ParserData currentData, CasualParserGenerationLayer nextLayer) {
        this.call(this.before, currentData, nextLayer);
        this.call(this.delegates, currentData, nextLayer);
        this.call(this.after, currentData, nextLayer);
    }

    private void call(List<CasualParserGenerationUnit> units, ParserData currentInfo, CasualParserGenerationLayer nextLayer) {
        ArrayList<CasualParserGenerationUnit> unitList = new ArrayList<CasualParserGenerationUnit>(units);
        units.clear();
        for (CasualParserGenerationUnit unit : unitList) {
            CasualParserGenerationCallback callback = unit.getCallback();
            ParserData delegatedInfo = unit.getDelegated();
            delegatedInfo.setComponent(UniversalComponents.CURRENT_PARSER_DATA, currentInfo);
            callback.call(delegatedInfo, nextLayer);
        }
    }

    @Override
    public CasualParserGenerationLayer delegateImmediately(CasualParserGenerationCallback callback, ParserData delegated) {
        return this.delegate(this.immediately, callback, delegated);
    }

    @Override
    public CasualParserGenerationLayer delegateBefore(CasualParserGenerationCallback callback, ParserData delegated) {
        return this.delegate(this.before, callback, delegated);
    }

    @Override
    public CasualParserGenerationLayer delegate(CasualParserGenerationCallback callback, ParserData delegated) {
        return this.delegate(this.delegates, callback, delegated);
    }

    @Override
    public CasualParserGenerationLayer delegateAfter(CasualParserGenerationCallback callback, ParserData delegated) {
        return this.delegate(this.after, callback, delegated);
    }

    public CasualParserGenerationLayer delegate(List<CasualParserGenerationUnit> units, CasualParserGenerationCallback callback, ParserData delegated) {
        PandaCasualParserGenerationUnit unit = new PandaCasualParserGenerationUnit(callback, delegated);
        units.add(unit);
        return this;
    }

    @Override
    public int countDelegates() {
        return this.immediately.size() + this.before.size() + this.delegates.size() + this.after.size();
    }
}

