/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss;

import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactorHollows;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReader;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;

public class AbyssPatternUtils {
    public static AbyssRedactorHollows extract(AbyssPattern pattern, SourceStream source) {
        TokenReader reader;
        AbyssExtractor extractor = pattern.extractor();
        List<TokenizedSource> gaps = extractor.extract(reader = source.toTokenReader());
        if (gaps == null) {
            throw new PandaParserException("Cannot parse source at line " + TokenUtils.getLine(source.toTokenizedSource()));
        }
        source.readDifference(reader);
        return new AbyssRedactorHollows(gaps);
    }

    public static boolean match(AbyssPattern pattern, TokenReader reader) {
        PandaTokenReader copyOfReader = new PandaTokenReader(reader);
        AbyssExtractor extractor = pattern.extractor();
        List<TokenizedSource> hollows = extractor.extract(copyOfReader);
        return hollows != null && hollows.size() == pattern.getAmountOfHollows();
    }

    public static int countGaps(AbyssPatternUnit[] units) {
        int gaps = 0;
        for (AbyssPatternUnit unit : units) {
            if (!unit.isAbyss()) continue;
            ++gaps;
        }
        return gaps;
    }
}

