/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor;

import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractorOpposites;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssTokenRepresentation;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;

class AbyssExtractorSource {
    private final TokenizedSource tokenizedSource;
    private final AbyssTokenRepresentation[] abyssRepresentations;

    protected AbyssExtractorSource(TokenizedSource tokenizedSource) {
        this.tokenizedSource = tokenizedSource;
        this.abyssRepresentations = new AbyssTokenRepresentation[tokenizedSource.size()];
        this.prepare();
    }

    private void prepare() {
        AbyssExtractorOpposites opposites = new AbyssExtractorOpposites();
        for (int i = 0; i < this.tokenizedSource.size(); ++i) {
            AbyssTokenRepresentation abyssRepresentation;
            TokenRepresentation representation = this.tokenizedSource.get(i);
            if (representation == null) {
                throw new PandaRuntimeException("Representation is null");
            }
            Token token = representation.getToken();
            boolean levelUp = opposites.report(token);
            int nestingLevel = levelUp ? opposites.getNestingLevel() - 1 : opposites.getNestingLevel();
            this.abyssRepresentations[i] = abyssRepresentation = new AbyssTokenRepresentation(representation, nestingLevel);
        }
    }

    protected AbyssTokenRepresentation[] getAbyssRepresentations() {
        return this.abyssRepresentations;
    }
}

