/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractorSource;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssTokenRepresentation;

public class AbyssExtractorSourceUtils {
    public static int countHardTypedUnits(AbyssPatternUnit[] units) {
        int i = 0;
        for (AbyssPatternUnit unit : units) {
            if (unit.isOptional() || unit.isAbyss()) continue;
            ++i;
        }
        return i;
    }

    public static int countGaps(AbyssPatternUnit[] units) {
        int i = 0;
        for (AbyssPatternUnit unit : units) {
            if (!unit.isAbyss()) continue;
            ++i;
        }
        return i;
    }

    public static int indexOf(AbyssExtractorSource source, Token search) {
        return AbyssExtractorSourceUtils.indexOf(source, search, 0, 0);
    }

    public static int indexOf(AbyssExtractorSource source, Token search, int minIndex, int maxNestingLevel) {
        return AbyssExtractorSourceUtils.indexOf(source, search, minIndex, maxNestingLevel, null);
    }

    public static int indexOf(AbyssExtractorSource source, Token search, int minIndex, int maxNestingLevel, @Nullable Token before) {
        AbyssTokenRepresentation[] representations = source.getAbyssRepresentations();
        for (int i = minIndex; i < representations.length; ++i) {
            AbyssTokenRepresentation representation = representations[i];
            if (representation.getNestingLevel() > maxNestingLevel) continue;
            Token token = representation.getTokenRepresentation().getToken();
            if (before != null && before.equals(token) && !before.equals(search)) break;
            if (!search.equals(token)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(AbyssExtractorSource source, Token search) {
        return AbyssExtractorSourceUtils.lastIndexOf(source, search, 0, 0, null);
    }

    public static int lastIndexOf(AbyssExtractorSource source, Token search, int minIndex, int maxNestingLevel, @Nullable Token before) {
        int startIndex;
        AbyssTokenRepresentation[] representations = source.getAbyssRepresentations();
        int indexOfBefore = before != null ? AbyssExtractorSourceUtils.indexOf(source, before) : -1;
        for (int i = startIndex = indexOfBefore != -1 ? indexOfBefore - 1 : representations.length - 1; i > minIndex - 1; --i) {
            Token token;
            AbyssTokenRepresentation representation = representations[i];
            if (representation.getNestingLevel() > maxNestingLevel || !search.equals(token = representation.getTokenRepresentation().getToken())) continue;
            return i;
        }
        return -1;
    }
}

