/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor;

import java.util.HashMap;
import java.util.Map;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactorHollows;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;

public class AbyssRedactor {
    private final AbyssRedactorHollows hollows;
    private final Map<String, Integer> map;

    public AbyssRedactor(AbyssRedactorHollows hollows) {
        this.hollows = hollows;
        this.map = new HashMap<String, Integer>();
    }

    public AbyssRedactor map(String ... names) {
        if (names.length != this.hollows.getGaps().size()) {
            throw new PandaParserException("Cannot map mismatched hollows");
        }
        for (int i = 0; i < names.length; ++i) {
            this.map.put(names[i], i);
        }
        return this;
    }

    public TokenizedSource get(String name) {
        Integer index = this.map.get(name);
        if (index == null) {
            throw new PandaRuntimeException("Hollow '" + name + "' does not exist");
        }
        return this.hollows.getGap(index);
    }
}

