/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternElement;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternNode;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternWildcard;
import org.panda_lang.panda.utilities.commons.arrays.CharArrayDistributor;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;
import org.panda_lang.panda.utilities.commons.redact.AttentiveContentReader;
import org.panda_lang.panda.utilities.commons.redact.BracketContentReader;

public class LexicalPatternCompiler {
    private static final char[] IDENTIFIER_CHARACTERS = CharacterUtils.mergeArrays(CharacterUtils.LETTERS, CharacterUtils.DIGITS, CharacterUtils.arrayOf('-'));

    public LexicalPatternElement compile(String pattern) {
        ArrayList<LexicalPatternElement> elements = new ArrayList<LexicalPatternElement>();
        StringBuilder unitBuilder = new StringBuilder();
        CharArrayDistributor distributor = new CharArrayDistributor(pattern.toCharArray());
        BracketContentReader contentReader = new BracketContentReader(distributor);
        while (distributor.hasNext()) {
            char currentChar = distributor.next();
            String identifier = null;
            if ((currentChar == '[' || currentChar == '<' || currentChar == '(' || currentChar == '*') && unitBuilder.length() > 0) {
                String unitContent = unitBuilder.toString();
                unitBuilder.setLength(0);
                if (!StringUtils.isEmpty(unitContent)) {
                    identifier = this.compileIdentifier(unitContent);
                    boolean current = false;
                    if (identifier != null) {
                        int identifierIndex = unitContent.trim().indexOf(identifier);
                        if (identifierIndex == 0) {
                            current = true;
                            unitContent = unitContent.substring(unitContent.indexOf(58) + 1);
                        } else {
                            unitContent = unitContent.substring(0, unitContent.lastIndexOf(58) - identifier.length());
                        }
                    }
                    if (!StringUtils.isEmpty(unitContent)) {
                        LexicalPatternUnit unit = new LexicalPatternUnit(unitContent);
                        if (current) {
                            unit.setIdentifier(identifier);
                            identifier = null;
                        }
                        elements.add(unit);
                    }
                }
            }
            char previousChar = distributor.getPrevious();
            LexicalPatternElement element = null;
            if (currentChar == '[') {
                element = this.compileOptional(contentReader.readCurrent());
            } else if (currentChar == '(') {
                element = this.compileVariant(contentReader.readCurrent());
            } else if (currentChar == '<') {
                element = new LexicalPatternWildcard(contentReader.readCurrent());
            } else if (currentChar == '*') {
                element = new LexicalPatternWildcard();
            } else {
                unitBuilder.append(currentChar);
            }
            if (element == null) continue;
            LexicalPatternElement.Isolation parentIsolation = LexicalPatternElement.Isolation.of(previousChar, distributor.getNext());
            LexicalPatternElement.Isolation commonIsolation = LexicalPatternElement.Isolation.merge(parentIsolation, element.getIsolationType());
            element.setIsolationType(commonIsolation);
            if (identifier != null) {
                element.setIdentifier(identifier);
            }
            elements.add(element);
        }
        if (unitBuilder.length() > 0) {
            LexicalPatternUnit unit = new LexicalPatternUnit(unitBuilder.toString());
            elements.add(unit);
        }
        if (elements.size() == 0) {
            throw new RuntimeException("Empty element");
        }
        return elements.size() == 1 ? (LexicalPatternElement)elements.get(0) : new LexicalPatternNode(elements);
    }

    private LexicalPatternElement compileOptional(String pattern) {
        LexicalPatternElement element = this.compile(pattern);
        element.setOptional(true);
        return element;
    }

    private LexicalPatternElement compileVariant(String pattern) {
        AttentiveContentReader contentReader = new AttentiveContentReader(pattern);
        List<String> variants = contentReader.select('|');
        ArrayList<LexicalPatternElement> elements = new ArrayList<LexicalPatternElement>(variants.size());
        for (String variant : variants) {
            elements.add(this.compile(variant));
        }
        return new LexicalPatternNode(elements, true);
    }

    @Nullable
    private String compileIdentifier(String pattern) {
        String identifier;
        if ((pattern = pattern.trim()).length() < 2 || !pattern.contains(":")) {
            return null;
        }
        if (pattern.endsWith(":")) {
            int lastIndex = pattern.lastIndexOf(" ");
            identifier = pattern.substring(lastIndex == -1 ? 0 : lastIndex + 1, pattern.length() - 1);
        } else {
            AttentiveContentReader contentReader = new AttentiveContentReader(pattern);
            List<String> variants = contentReader.select(':');
            if (variants.size() < 2) {
                return null;
            }
            identifier = variants.get(0).trim();
            if (identifier.contains(" ")) {
                return null;
            }
        }
        if (StringUtils.isEmpty(identifier)) {
            return null;
        }
        if (StringUtils.containsOtherCharacters(identifier, new char[][]{IDENTIFIER_CHARACTERS})) {
            return null;
        }
        return identifier;
    }
}

