/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor;

import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternElement;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternNode;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.LexicalExtractorResult;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.processed.ProcessedValue;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.processed.WildcardProcessor;
import org.panda_lang.panda.utilities.commons.arrays.ArrayDistributor;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class LexicalExtractorWorker<T> {
    @Nullable
    private final WildcardProcessor<T> wildcardProcessor;

    public LexicalExtractorWorker(@Nullable WildcardProcessor<T> wildcardProcessor) {
        this.wildcardProcessor = wildcardProcessor;
    }

    public LexicalExtractorResult<T> extract(LexicalPatternElement pattern, String phrase) {
        if (pattern.isUnit()) {
            boolean matched = phrase.equals(pattern.toUnit().getValue());
            if (!matched) {
                return new LexicalExtractorResult(false);
            }
            return new LexicalExtractorResult(true).addIdentifier(pattern.getIdentifier());
        }
        if (pattern.isWildcard()) {
            String wildcard = phrase.trim();
            if (this.wildcardProcessor != null) {
                T result = this.wildcardProcessor.handle(wildcard);
                if (result == null) {
                    return new LexicalExtractorResult(false);
                }
                return new LexicalExtractorResult<T>(true).addProcessedValue(new ProcessedValue<T>(result, pattern.getIdentifier())).addIdentifier(pattern.getIdentifier()).addWildcard(wildcard);
            }
            return new LexicalExtractorResult(true).addIdentifier(pattern.getIdentifier()).addWildcard(wildcard);
        }
        LexicalPatternNode node = pattern.toNode();
        if (node.isVariant()) {
            return this.matchVariant(node, phrase);
        }
        List<LexicalPatternElement> elements = node.getElements();
        String[] dynamics = this.matchUnits(phrase, elements);
        if (dynamics == null) {
            return new LexicalExtractorResult(false);
        }
        return this.matchDynamics(elements, dynamics);
    }

    @Nullable
    private String[] matchUnits(String phrase, List<LexicalPatternElement> elements) {
        int index;
        Stack<LexicalPatternUnit> units = new Stack<LexicalPatternUnit>();
        String[] dynamics = new String[elements.size()];
        for (int i = index = 0; i < elements.size(); ++i) {
            LexicalPatternElement nextElement;
            LexicalExtractorResult<T> result;
            LexicalPatternElement element = elements.get(i);
            if (!element.isUnit()) continue;
            LexicalPatternUnit unit = element.toUnit();
            units.push(unit);
            ArrayDistributor<LexicalPatternUnit> unitArrayDistributor = new ArrayDistributor<LexicalPatternUnit>(units, LexicalPatternUnit.class);
            unitArrayDistributor.reverse();
            int unitIndex = -1;
            for (LexicalPatternUnit currentUnit : unitArrayDistributor) {
                if (index < 0) {
                    return null;
                }
                if (StringUtils.isEmpty(unit.getValue())) {
                    if (unit.isOptional() || !unit.getIsolationType().isAny()) continue;
                    ++index;
                    continue;
                }
                LexicalPatternUnit previousUnit = unitArrayDistributor.getPrevious();
                if (currentUnit.equals(previousUnit)) {
                    previousUnit = null;
                }
                boolean isolation = unit.getIsolationType().isStart() || previousUnit != null && previousUnit.getIsolationType().isEnd();
                unitIndex = phrase.indexOf(unit.getValue(), index + (isolation ? 1 : 0));
                if (unitIndex != -1 || unit.isOptional()) break;
                unitIndex = -2;
                if (previousUnit == null) break;
                index -= previousUnit.getValue().length();
            }
            if (unitIndex == -2) {
                return null;
            }
            if (unitIndex == -1) continue;
            String before = phrase.substring(index, unitIndex).trim();
            if (unit.isOptional() && i + 1 < elements.size() && !StringUtils.isEmpty(before) && (result = this.extract(nextElement = elements.get(i + 1), before)).isMatched()) {
                unitIndex = -unit.getValue().length() + index;
                before = null;
            }
            if (!StringUtils.isEmpty(before)) {
                if (i - 1 < 0) {
                    return null;
                }
                dynamics[i - 1] = before;
            }
            index = unitIndex + unit.getValue().length();
        }
        if (index < phrase.length()) {
            dynamics[dynamics.length - 1] = phrase.substring(index, phrase.length());
        }
        return dynamics;
    }

    private LexicalExtractorResult<T> matchDynamics(List<LexicalPatternElement> elements, String[] dynamics) {
        LexicalExtractorResult<T> result = new LexicalExtractorResult<T>(true);
        for (int i = 0; i < elements.size(); ++i) {
            LexicalPatternElement nodeElement = elements.get(i);
            if (nodeElement.isUnit() || dynamics.length == 0 && nodeElement.isOptional()) continue;
            String nodeContent = dynamics[i];
            dynamics[i] = null;
            if (nodeContent == null) {
                return new LexicalExtractorResult(false);
            }
            LexicalExtractorResult<T> nodeElementResult = this.extract(nodeElement, nodeContent);
            if (!nodeElementResult.isMatched()) {
                return new LexicalExtractorResult(false);
            }
            result.addIdentifier(nodeElement.getIdentifier());
            result.merge(nodeElementResult);
        }
        for (String dynamicContent : dynamics) {
            if (StringUtils.isEmpty(dynamicContent)) continue;
            return new LexicalExtractorResult(false);
        }
        return result;
    }

    private LexicalExtractorResult<T> matchVariant(LexicalPatternNode variantNode, String phrase) {
        if (!variantNode.isVariant()) {
            throw new RuntimeException("The specified node is not marked as a variant node");
        }
        for (LexicalPatternElement variantElement : variantNode.getElements()) {
            LexicalExtractorResult<T> result = this.extract(variantElement, phrase);
            if (!result.isMatched()) continue;
            return result;
        }
        return new LexicalExtractorResult(false);
    }
}

