/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.distributor;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReader;

public class PandaSourceStream
implements SourceStream {
    private TokenizedSource source;
    private TokenizedSource cachedSource;

    public PandaSourceStream(TokenizedSource source) {
        this.source = source;
        this.cachedSource = source;
    }

    @Override
    public TokenRepresentation read() {
        if (this.source.size() < 1) {
            throw new NoSuchElementException("SourceStream is empty, cannot read next TokenRepresentation");
        }
        TokenRepresentation representation = this.source.get(0);
        List<TokenRepresentation> tokens = this.source.getTokensRepresentations().subList(1, this.source.size());
        this.cachedSource = this.source;
        this.source = new PandaTokenizedSource(tokens);
        return representation;
    }

    @Override
    public TokenizedSource read(int length) {
        TokenRepresentation[] array = new TokenRepresentation[length];
        for (int i = 0; i < array.length && this.hasUnreadSource(); ++i) {
            array[i] = this.read();
        }
        return new PandaTokenizedSource(array);
    }

    @Override
    public TokenizedSource readDifference(TokenReader reader) {
        int length = reader.getIndex() + 1;
        return this.read(length);
    }

    @Override
    public TokenizedSource readLineResidue() {
        ArrayList<TokenRepresentation> residue = new ArrayList<TokenRepresentation>();
        int currentLine = this.getCurrentLine();
        while (this.hasUnreadSource()) {
            TokenRepresentation representation = this.read();
            if (representation.getLine() != currentLine) {
                this.restoreCachedSource();
                break;
            }
            residue.add(representation);
        }
        return new PandaTokenizedSource(residue);
    }

    @Override
    public void restoreCachedSource() {
        this.source = this.cachedSource;
    }

    @Override
    public boolean hasUnreadSource() {
        return this.source.size() > 0;
    }

    @Override
    public TokenReader toTokenReader() {
        return new PandaTokenReader(this.toTokenizedSource());
    }

    @Override
    public TokenizedSource toTokenizedSource() {
        return new PandaTokenizedSource(new ArrayList<TokenRepresentation>(this.source.getTokensRepresentations()));
    }

    public String toString() {
        return "PandaSourceStream['" + this.source + "']";
    }
}

