/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation;

import org.panda_lang.panda.framework.design.architecture.statement.Container;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGeneration;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;

public class ContainerParser
implements Parser {
    private final Container container;

    public ContainerParser(Container container) {
        this.container = container;
    }

    public void parse(ParserData data, TokenizedSource body) {
        CasualParserGeneration generation = data.getComponent(UniversalComponents.GENERATION);
        PipelineRegistry pipelineRegistry = data.getComponent(UniversalComponents.PIPELINE);
        ParserPipeline pipeline = pipelineRegistry.getPipeline("scope");
        PandaSourceStream stream = new PandaSourceStream(body);
        data.setComponent(UniversalComponents.SOURCE_STREAM, stream);
        Container previousContainer = data.getComponent(PandaComponents.CONTAINER);
        data.setComponent(PandaComponents.CONTAINER, this.container);
        while (stream.hasUnreadSource()) {
            UnifiedParser parser = pipeline.handle(stream);
            if (parser == null) {
                throw new PandaParserException("Unrecognized syntax at line " + TokenUtils.getLine(stream.toTokenizedSource()));
            }
            int sourceLength = stream.getUnreadLength();
            parser.parse(data);
            generation.executeImmediately(data);
            data.setComponent(PandaComponents.CONTAINER, this.container);
            if (sourceLength != stream.getUnreadLength()) continue;
            throw new PandaParserException(parser.getClass().getSimpleName() + " did nothing with source at line " + TokenUtils.getLine(stream.toTokenizedSource()));
        }
        data.setComponent(PandaComponents.CONTAINER, previousContainer);
    }
}

