/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.prototype.field;

import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.field.FieldVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PandaPrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGeneration;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationType;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactorHollows;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeComponents;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.field.FieldParserHandler;
import org.panda_lang.panda.language.runtime.expression.Expression;

@ParserRegistration(target={"prototype"}, parserClass=FieldParser.class, handlerClass=FieldParserHandler.class, priority=1)
public class FieldParser
implements UnifiedParser {
    protected static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** ;").build();
    protected static final AbyssPattern ASSIGNATION_PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** = +* ;").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGeneration generation = data.getComponent(UniversalComponents.GENERATION);
        SourceStream stream = data.getComponent(UniversalComponents.SOURCE_STREAM);
        PandaSourceStream copyOfStream = new PandaSourceStream(stream.toTokenizedSource());
        List<TokenizedSource> hollows = ASSIGNATION_PATTERN.extractor().extract(copyOfStream.toTokenReader());
        FieldDeclarationCasualParserCallback callback = hollows == null || hollows.size() < 2 ? new FieldDeclarationCasualParserCallback(false) : new FieldDeclarationCasualParserCallback(true);
        generation.getLayer(CasualParserGenerationType.HIGHER).delegateImmediately(callback, data.fork());
    }

    private static class FieldAssignationCasualParserCallback
    implements CasualParserGenerationCallback {
        private final PrototypeField field;
        private final AbyssRedactor redactor;

        public FieldAssignationCasualParserCallback(PrototypeField field, AbyssRedactor redactor) {
            this.field = field;
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            ExpressionParser expressionParser = new ExpressionParser();
            TokenizedSource right = this.redactor.get("right");
            Expression expressionValue = expressionParser.parse(delegatedData, right);
            if (expressionValue == null) {
                throw new PandaParserException("Cannot parse expression '" + right + "'");
            }
            this.field.setDefaultValue(expressionValue);
        }
    }

    private static class FieldDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private final boolean assignation;

        private FieldDeclarationCasualParserCallback(boolean assignation) {
            this.assignation = assignation;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            AbyssRedactorHollows hollows = AbyssPatternAssistant.extract(this.assignation ? ASSIGNATION_PATTERN : PATTERN, delegatedData);
            AbyssRedactor redactor = new AbyssRedactor(hollows);
            if (this.assignation) {
                redactor.map("left", "right");
            } else {
                redactor.map("left");
            }
            TokenizedSource left = redactor.get("left");
            ClassPrototype prototype = delegatedData.getComponent(ClassPrototypeComponents.CLASS_PROTOTYPE);
            String name = null;
            FieldVisibility visibility = null;
            ClassPrototype type = null;
            boolean isStatic = false;
            boolean mutable = false;
            boolean nullable = false;
            block16: for (int i = 0; i < left.size(); ++i) {
                TokenRepresentation representation = left.get(i);
                Token token = representation.getToken();
                if (token.getType() == TokenType.UNKNOWN && i == left.size() - 1) {
                    name = token.getTokenValue();
                    continue;
                }
                if (token.getType() == TokenType.UNKNOWN && i == left.size() - 2) {
                    String returnTypeName = token.getTokenValue();
                    PandaScript script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
                    ModuleLoader registry = script.getModuleLoader();
                    type = registry.forClass(returnTypeName);
                    continue;
                }
                switch (token.getTokenValue()) {
                    case "method": {
                        visibility = FieldVisibility.PUBLIC;
                        continue block16;
                    }
                    case "local": {
                        visibility = FieldVisibility.LOCAL;
                        continue block16;
                    }
                    case "hidden": {
                        visibility = FieldVisibility.HIDDEN;
                        continue block16;
                    }
                    case "static": {
                        isStatic = true;
                        visibility = visibility != null ? visibility : FieldVisibility.PUBLIC;
                        continue block16;
                    }
                    case "mutable": {
                        mutable = true;
                        continue block16;
                    }
                    case "nullable": {
                        nullable = true;
                        continue block16;
                    }
                    default: {
                        throw new PandaParserException("Unexpected token at line " + (representation.getLine() + 1) + ": " + token.getTokenValue());
                    }
                }
            }
            int fieldIndex = prototype.getFields().getAmountOfFields();
            if (visibility == null) {
                visibility = FieldVisibility.LOCAL;
            }
            PandaPrototypeField field = PandaPrototypeField.builder().fieldIndex(fieldIndex).type(type).name(name).visibility(visibility).isStatic(isStatic).mutable(mutable).nullable(nullable).build();
            prototype.getFields().addField(field);
            if (this.assignation) {
                nextLayer.delegate(new FieldAssignationCasualParserCallback(field, redactor), delegatedData);
            }
        }
    }
}

