/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.prototype.method;

import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScope;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodScope;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethod;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.parameter.Parameter;
import org.panda_lang.panda.framework.design.architecture.prototype.parameter.ParameterUtils;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.CasualParserGenerationAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.parser.implementation.ScopeParser;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeComponents;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.method.MethodParserHandler;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.parameter.ParameterParser;

@ParserRegistration(target={"prototype"}, parserClass=MethodParser.class, handlerClass=MethodParserHandler.class, priority=2)
public class MethodParser
implements UnifiedParser {
    protected static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** ( +** ) { +* }").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGenerationAssistant.delegateImmediately(data, new MethodDeclarationCasualParserCallback());
    }

    private static class MethodBodyCasualParserCallback
    implements CasualParserGenerationCallback {
        private final MethodScope methodScope;
        private final AbyssRedactor redactor;

        private MethodBodyCasualParserCallback(MethodScope methodScope, AbyssRedactor redactor) {
            this.methodScope = methodScope;
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            ScopeParser.createParser(this.methodScope, delegatedData).initializeLinker(delegatedData.getComponent(ClassPrototypeComponents.CLASS_SCOPE), this.methodScope).parse(this.redactor.get("method-body"));
        }
    }

    private static class MethodDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private MethodDeclarationCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, delegatedData, "method-declaration", "method-parameters", "method-body");
            TokenizedSource methodDeclaration = redactor.get("method-declaration");
            ClassPrototype prototype = delegatedData.getComponent(ClassPrototypeComponents.CLASS_PROTOTYPE);
            ClassScope classScope = delegatedData.getComponent(ClassPrototypeComponents.CLASS_SCOPE);
            MethodVisibility visibility = null;
            ClassPrototype returnType = null;
            String methodName = null;
            boolean isStatic = false;
            block12: for (int i = 0; i < methodDeclaration.size(); ++i) {
                TokenRepresentation representation = methodDeclaration.get(i);
                Token token = representation.getToken();
                if (token.getType() == TokenType.UNKNOWN && i == methodDeclaration.size() - 1) {
                    methodName = token.getTokenValue();
                    continue;
                }
                if (token.getType() == TokenType.UNKNOWN && i == methodDeclaration.size() - 2) {
                    Object script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
                    ModuleLoader registry = ((PandaScript)script).getModuleLoader();
                    String returnTypeName = token.getTokenValue();
                    returnType = registry.forClass(returnTypeName);
                    continue;
                }
                switch (token.getTokenValue()) {
                    case "method": {
                        visibility = MethodVisibility.PUBLIC;
                        continue block12;
                    }
                    case "local": {
                        visibility = MethodVisibility.LOCAL;
                        continue block12;
                    }
                    case "hidden": {
                        visibility = MethodVisibility.HIDDEN;
                        continue block12;
                    }
                    case "static": {
                        isStatic = true;
                        visibility = visibility != null ? visibility : MethodVisibility.PUBLIC;
                        continue block12;
                    }
                    default: {
                        throw new PandaParserException("Unexpected token at line " + (representation.getLine() + 1) + ": " + token.getTokenValue());
                    }
                }
            }
            TokenizedSource parametersSource = redactor.get("method-parameters");
            ParameterParser parameterParser = new ParameterParser();
            List<Parameter> parameters = parameterParser.parse(delegatedData, parametersSource);
            ClassPrototype[] parameterTypes = ParameterUtils.toTypes(parameters);
            MethodScope methodScope = new MethodScope(methodName, parameters);
            ParameterUtils.addAll(methodScope.getVariables(), parameters, 0);
            delegatedData.setComponent(PandaComponents.SCOPE, methodScope);
            PandaMethod method = PandaMethod.builder().prototype(prototype).parameterTypes(parameterTypes).methodName(methodName).visibility(visibility).returnType(returnType).isStatic(isStatic).methodBody(new PandaMethodCallback(methodScope)).build();
            prototype.getMethods().registerMethod(method);
            nextLayer.delegate(new MethodBodyCasualParserCallback(methodScope, redactor), delegatedData);
        }
    }
}

