/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.prototype.parameter;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.parameter.PandaParameter;
import org.panda_lang.panda.framework.design.architecture.prototype.parameter.Parameter;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;

public class ParameterParser
implements Parser {
    public List<Parameter> parse(ParserData info, TokenizedSource tokenizedSource) {
        TokenRepresentation[] tokenRepresentations = tokenizedSource.toArray();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(tokenRepresentations.length / 3 + 1);
        if (tokenizedSource.size() == 0) {
            return parameters;
        }
        for (int i = 0; i < tokenRepresentations.length; i += 3) {
            TokenRepresentation separatorRepresentation;
            Token separator;
            TokenRepresentation parameterTypeRepresentation = tokenRepresentations[i];
            TokenRepresentation parameterNameRepresentation = tokenRepresentations[i + 1];
            String parameterType = parameterTypeRepresentation.getToken().getTokenValue();
            String parameterName = parameterNameRepresentation.getToken().getTokenValue();
            PandaScript script = info.getComponent(PandaComponents.PANDA_SCRIPT);
            ModuleLoader moduleLoader = script.getModuleLoader();
            ClassPrototype type = moduleLoader.forClass(parameterType);
            if (type == null) {
                throw new PandaParserException("Unknown type '" + parameterType + "'");
            }
            PandaParameter parameter = new PandaParameter(type, parameterName);
            parameters.add(parameter);
            if (i + 2 >= tokenRepresentations.length || (separator = (separatorRepresentation = tokenRepresentations[i + 2]).getToken()).getType() == TokenType.SEPARATOR) continue;
            throw new PandaParserException("Unexpected token " + separatorRepresentation);
        }
        return parameters;
    }
}

