/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block.conditional;

import org.panda_lang.panda.framework.design.architecture.dynamic.Block;
import org.panda_lang.panda.framework.design.architecture.dynamic.block.conditional.ConditionalBlock;
import org.panda_lang.panda.framework.design.architecture.dynamic.block.conditional.ElseBlock;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block.BlockComponents;
import org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block.conditional.ConditionalBlockParserHandler;
import org.panda_lang.panda.language.runtime.expression.Expression;

@ParserRegistration(target={"block"}, parserClass=ConditionalBlockParser.class, handlerClass=ConditionalBlockParserHandler.class)
public class ConditionalBlockParser
implements UnifiedParser {
    protected static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+* ( +* )").build();

    @Override
    public void parse(ParserData data) {
        SourceStream stream = data.getComponent(UniversalComponents.SOURCE_STREAM);
        ParserData parentInfo = data.getComponent(UniversalComponents.PARENT_DATA);
        if (stream.getUnreadLength() == 1) {
            ElseBlock elseBlock = new ElseBlock();
            Block previousBlock = parentInfo.getComponent(BlockComponents.PREVIOUS_BLOCK);
            if (!(previousBlock instanceof ConditionalBlock)) {
                throw new PandaParserException("The Else-block without associated If-block at line " + TokenUtils.getLine(stream.toTokenizedSource()));
            }
            ConditionalBlock conditionalBlock = (ConditionalBlock)previousBlock;
            conditionalBlock.setElseBlock(elseBlock);
            data.setComponent(BlockComponents.BLOCK, elseBlock);
            data.setComponent(BlockComponents.UNLISTED_BLOCK, true);
            return;
        }
        AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, data, "condition-type", "condition-expression");
        TokenizedSource conditionType = redactor.get("condition-type");
        TokenizedSource conditionExpression = redactor.get("condition-expression");
        ExpressionParser expressionParser = new ExpressionParser();
        Expression expression = expressionParser.parse(data, conditionExpression);
        ConditionalBlock conditionalBlock = new ConditionalBlock(expression);
        data.setComponent(BlockComponents.BLOCK, conditionalBlock);
        switch (conditionType.asString()) {
            case "if": {
                break;
            }
            case "else if": {
                Block previousBlock = parentInfo.getComponent(BlockComponents.PREVIOUS_BLOCK);
                if (!(previousBlock instanceof ConditionalBlock)) {
                    throw new PandaParserException("The If-Else-block without associated If-block at line " + TokenUtils.getLine(stream.toTokenizedSource()));
                }
                ConditionalBlock previousConditionalBlock = (ConditionalBlock)previousBlock;
                conditionalBlock.setElseBlock(previousConditionalBlock);
                data.setComponent(BlockComponents.UNLISTED_BLOCK, true);
                break;
            }
            default: {
                throw new PandaParserException("Unrecognized condition type at line " + TokenUtils.getLine(conditionType));
            }
        }
    }
}

