/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.runtime.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.language.runtime.memory.MemorySegment;

public class PandaMemorySegment
implements MemorySegment {
    private final int typeID;
    private final String type;
    private final AtomicInteger instanceIDAssigner;
    private final Stack<Integer> free;
    private final List<Object> instances;

    public PandaMemorySegment(int typeID, String type) {
        this.typeID = typeID;
        this.type = type;
        this.instanceIDAssigner = new AtomicInteger();
        this.free = new Stack();
        this.instances = new ArrayList<Object>();
    }

    @Override
    public int put(Object value) {
        if (this.free.size() > 0) {
            int id = this.free.pop();
            this.instances.set(id, value);
            return id;
        }
        int id = this.instanceIDAssigner.getAndIncrement();
        this.fillAndSet(id, value);
        return id;
    }

    protected void fillAndSet(int index, Object value) {
        if (index > this.instances.size() - 1) {
            for (int i = this.instances.size(); i < index; ++i) {
                this.instances.add(null);
            }
            this.instances.add(value);
        } else {
            this.instances.set(index, value);
        }
    }

    @Override
    @Nullable
    public <T> T destroy(int pointer) {
        if (this.instances.size() > pointer) {
            Object element = this.instances.remove(pointer);
            this.free.push(pointer);
            return (T)element;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T get(int pointer) {
        return (T)(this.instances.size() > pointer ? this.instances.get(pointer) : null);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getTypeID() {
        return this.typeID;
    }
}

