/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.panda_lang.panda.utilities.annotations.AnnotationScannerStore;
import org.panda_lang.panda.utilities.annotations.AnnotationsScanner;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerFile;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerProcess;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerUtils;
import org.panda_lang.panda.utilities.annotations.monads.AnnotationsFilter;
import org.panda_lang.panda.utilities.annotations.monads.filters.AnonymousFileFilter;
import org.panda_lang.panda.utilities.annotations.monads.filters.JavaFilter;
import org.panda_lang.panda.utilities.annotations.monads.filters.PackageFileFilter;
import org.panda_lang.panda.utilities.annotations.monads.filters.PublicClassFileFilter;
import org.panda_lang.panda.utilities.commons.collection.Sets;

public class AnnotationsScannerProcessBuilder {
    protected final AnnotationsScanner scanner;
    protected final AnnotationScannerStore store;
    protected final List<AnnotationsFilter<URL>> urlFilters;
    protected final List<AnnotationsFilter<AnnotationsScannerFile>> fileFilters;
    protected final List<AnnotationsFilter<ClassFile>> classFileFilters;

    AnnotationsScannerProcessBuilder(AnnotationsScanner scanner, AnnotationScannerStore store) {
        this.scanner = scanner;
        this.store = store;
        this.urlFilters = new ArrayList<AnnotationsFilter<URL>>(1);
        this.fileFilters = new ArrayList<AnnotationsFilter<AnnotationsScannerFile>>(1);
        this.classFileFilters = new ArrayList<AnnotationsFilter<ClassFile>>(1);
    }

    public AnnotationsScannerProcessBuilder addDefaultFilters() {
        this.addURLFilter(new JavaFilter());
        this.addFileFilters(new AnonymousFileFilter(), new PackageFileFilter(true, AnnotationsScannerUtils.PANDA_PACKAGES));
        this.addClassFileFilters(new PublicClassFileFilter());
        return this;
    }

    public AnnotationsScannerProcessBuilder addDefaultProjectFilters(String ... packageNames) {
        this.addURLFilter(new JavaFilter()).addFileFilters(new PackageFileFilter(false, packageNames));
        return this;
    }

    public AnnotationsScannerProcessBuilder addURLFilter(AnnotationsFilter<URL> ... urlFilters) {
        this.urlFilters.addAll(Sets.newHashSet(urlFilters));
        return this;
    }

    public AnnotationsScannerProcessBuilder addFileFilters(AnnotationsFilter<AnnotationsScannerFile> ... fileFilters) {
        this.fileFilters.addAll(Sets.newHashSet(fileFilters));
        return this;
    }

    public AnnotationsScannerProcessBuilder addClassFileFilters(AnnotationsFilter<ClassFile> ... classFileFilters) {
        this.classFileFilters.addAll(Sets.newHashSet(classFileFilters));
        return this;
    }

    public AnnotationsScannerProcess fetch() {
        return new AnnotationsScannerProcess(this).fetch();
    }
}

